<?php

add_filter('zcpri/get-condition-type-group-customer_value', 'zc_pri_get_condition_type_customer_value_used_coupons', 10, 2);
if (!function_exists('zc_pri_get_condition_type_customer_value_used_coupons')) {

    function zc_pri_get_condition_type_customer_value_used_coupons($list = array(), $args) {
        $list['customer_value_used_coupons'] = __('Used Coupons', 'zc-woo-pricely');
         $list['customer_value_never_use_coupons'] = __('Never Use Coupons', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_customer_value_used_coupons_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_customer_value_used_coupons_fields')) {

    function zc_pri_get_condition_type_customer_value_used_coupons_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'date_type',
                'type' => 'select2',
                'default' => 'all_time',
                'options' => array(
                    'all_time' => __('All time', 'zc-woo-pricely'),
                    'current' => __('Current', 'zc-woo-pricely'),
                    'hours' => __('Hours', 'zc-woo-pricely'),
                    'days' => __('Days', 'zc-woo-pricely'),
                    'weeks' => __('Weeks', 'zc-woo-pricely'),
                    'months' => __('Months', 'zc-woo-pricely'),
                    'years' => __('Years', 'zc-woo-pricely'),
                ),
                'fold_id' => 'date_type',
                'width' => '98%',
                'box_width' => '17%',
            ),
            array(
                'id' => 'current',
                'type' => 'select2',
                'default' => 'day',
                'options' => array(
                    'day' => __('Day', 'zc-woo-pricely'),
                    'week' => __('Week', 'zc-woo-pricely'),
                    'month' => __('Month', 'zc-woo-pricely'),
                    'year' => __('Year', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('current'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '15%',
            ),
            array(
                'id' => 'date_offset',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '1',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '98%',
                'box_width' => '15%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('hours', 'days', 'weeks', 'months', 'years'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
           array(
                'id' => 'all_time_applied_coupons',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Coupons...',
                'data' => 'posts:shop_coupon',
               'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '100%',
                'box_width' => '64%',
            ),
             array(
                'id' => 'applied_coupons',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Coupons...',
                'data' => 'posts:shop_coupon',
               'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '100%',
                'box_width' => '49%',
            ),
        );

        $fields['customer_value_used_coupons'] = $flds;
        $fields['customer_value_never_use_coupons'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-customer_value_used_coupons', 'zc_pri_validate_condition_customer_value_used_coupons', 10, 3);
if (!function_exists('zc_pri_validate_condition_customer_value_used_coupons')) {

    function zc_pri_validate_condition_customer_value_used_coupons($rule, $args) {


        $rule_applied_coupons = $rule['all_time_applied_coupons'];
        if ($rule['date_type'] != 'all_time' && $rule['date_type'] != '') {
            $rule_applied_coupons = $rule['applied_coupons'];
        }
        if(!is_array($rule_applied_coupons)){
            return false;
        }

        $from_date = WooPricelyUtil::get_date_from_rule_value($rule);

        $coupons = WooPricelyUtil::get_customer_coupon_used(get_current_user_id(), $from_date, true);
  
    
        return WooPricely_Validation_Util::validate_list_list($coupons, $rule_applied_coupons, 'in_list');
    }

}


add_filter('zcpri/validate-condition-customer_value_never_use_coupons', 'zc_pri_validate_condition_customer_value_never_use_coupons', 10, 3);
if (!function_exists('zc_pri_validate_condition_customer_value_never_use_coupons')) {

    function zc_pri_validate_condition_customer_value_never_use_coupons($rule, $args) {


        $rule_applied_coupons = $rule['all_time_applied_coupons'];
        if ($rule['date_type'] != 'all_time' && $rule['date_type'] != '') {
            $rule_applied_coupons = $rule['applied_coupons'];
        }
        if(!is_array($rule_applied_coupons)){
            return false;
        }

        $from_date = WooPricelyUtil::get_date_from_rule_value($rule);

        $coupons = WooPricelyUtil::get_customer_coupon_used(get_current_user_id(), $from_date, true);
     
        return !(WooPricely_Validation_Util::validate_list_list($coupons, $rule_applied_coupons, 'in_list'));
    }

}