<?php

add_filter('zcpri/get-condition-type-group-customer_value', 'zc_pri_get_condition_type_customer_value_orders_count', 10, 2);
if (!function_exists('zc_pri_get_condition_type_customer_value_orders_count')) {

    function zc_pri_get_condition_type_customer_value_orders_count($list = array(), $args) {
        $list['customer_value_orders_count'] = __('Number Of Orders', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_customer_value_orders_count_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_customer_value_orders_count_fields')) {

    function zc_pri_get_condition_type_customer_value_orders_count_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'date_type',
                'type' => 'select2',
                'default' => 'all_time',
                'options' => array(
                    'all_time' => __('All time', 'zc-woo-pricely'),
                    'current' => __('Current', 'zc-woo-pricely'),
                    'hours' => __('Hours', 'zc-woo-pricely'),
                    'days' => __('Days', 'zc-woo-pricely'),
                    'weeks' => __('Weeks', 'zc-woo-pricely'),
                    'months' => __('Months', 'zc-woo-pricely'),
                    'years' => __('Years', 'zc-woo-pricely'),
                ),
                'fold_id' => 'date_type',
                'width' => '98%',
                'box_width' => '17%',
            ),
            array(
                'id' => 'current',
                'type' => 'select2',
                'default' => 'day',
                'options' => array(
                    'day' => __('Day', 'zc-woo-pricely'),
                    'week' => __('Week', 'zc-woo-pricely'),
                    'month' => __('Month', 'zc-woo-pricely'),
                    'year' => __('Year', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('current'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '15%',
            ),
            array(
                'id' => 'date_offset',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '1',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '98%',
                'box_width' => '15%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => array('hours', 'days', 'weeks', 'months', 'years'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '98%',
                'box_width' => '32%',
            ),
            array(
                'id' => 'all_time_compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'all_time',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '99%',
                'box_width' => '47%',
            ),
            array(
                'id' => 'orders_count',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '1',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '17%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['customer_value_orders_count'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-customer_value_orders_count', 'zc_pri_validate_condition_customer_value_orders_count', 10, 3);
if (!function_exists('zc_pri_validate_condition_customer_value_orders_count')) {

    function zc_pri_validate_condition_customer_value_orders_count($rule, $args) {


        $compare = $rule['all_time_compare'];
        if ($rule['date_type'] != 'all_time' && $rule['date_type'] != '') {
            $compare = $rule['compare'];
        }

        $from_date = WooPricelyUtil::get_date_from_rule_value($rule);

        $orders_count = WooPricelyUtil::get_customer_orders_count(get_current_user_id(), $from_date, true);

        return WooPricely_Validation_Util::validate_value($compare, $orders_count, $rule['orders_count'], 'no');
    }

}
