<?php

add_filter('zcpri/get-condition-type-group-customer_value', 'zc_pri_get_condition_type_customer_value_last_order_date', 10, 2);
if (!function_exists('zc_pri_get_condition_type_customer_value_last_order_date')) {

    function zc_pri_get_condition_type_customer_value_last_order_date($list = array(), $args) {
        $list['customer_value_last_order_date'] = __('Last Order Date', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_customer_value_last_order_date_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_customer_value_last_order_date_fields')) {

    function zc_pri_get_condition_type_customer_value_last_order_date_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'date_compare',
                'type' => 'select2',
                'default' => 'after',
                'options' => array(
                    '<=' => __('Earlier than', 'zc-woo-pricely'),
                    '>=' => __('Within the past', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '29%',
            ),
            array(
                'id' => 'date_type',
                'type' => 'select2',
                'default' => 'days',
                'options' => array(
                    'current' => __('Current', 'zc-woo-pricely'),
                    'hours' => __('Hours', 'zc-woo-pricely'),
                    'days' => __('Days', 'zc-woo-pricely'),
                    'weeks' => __('Weeks', 'zc-woo-pricely'),
                    'months' => __('Months', 'zc-woo-pricely'),
                    'years' => __('Years', 'zc-woo-pricely'),
                ),
                'fold_id' => 'date_type',
                'width' => '98%',
                'box_width' => '20%',
            ),
            array(
                'id' => 'current',
                'type' => 'select2',
                'default' => 'day',
                'options' => array(
                    'day' => __('Day', 'zc-woo-pricely'),
                    'week' => __('Week', 'zc-woo-pricely'),
                    'month' => __('Month', 'zc-woo-pricely'),
                    'year' => __('Year', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'current',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'width' => '100%',
                'box_width' => '32%',
            ),
            array(
                'id' => 'date_offset',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '1',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '32%',
                'fold' => array(
                    'target' => 'date_type',
                    'attribute' => 'value',
                    'value' => 'current',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => false,
                ),
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['customer_value_last_order_date'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-customer_value_last_order_date', 'zc_pri_validate_condition_customer_value_last_order_date', 10, 3);
if (!function_exists('zc_pri_validate_condition_customer_value_last_order_date')) {

    function zc_pri_validate_condition_customer_value_last_order_date($rule, $args) {

        $last_order = wc_get_customer_last_order(get_current_user_id());
        if ($last_order == false) {
            return false;
        }
        $from_date = WooPricelyUtil::get_date_from_rule_value($rule);
        $last_order_date = $last_order->get_date_paid(false)->format('Y-m-d H:i:s');

        return WooPricely_Validation_Util::validate_date($rule['date_compare'],$last_order_date ,  $from_date, 'Y-m-d H:i:s', 'Y-m-d H:i:s');
    }

}