<?php

add_filter('zcpri/get-condition-type-group-cart', 'zc_pri_get_condition_type_total_weight', 10, 2);
if (!function_exists('zc_pri_get_condition_type_total_weight')) {

    function zc_pri_get_condition_type_total_weight($list = array(), $args) {
        $weight_text = str_replace('[0]', get_option('woocommerce_weight_unit'), __('Cart Total Weight ([0])', 'zc-woo-pricely'));
        $list['cart_total_weight'] = $weight_text;
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_total_weight_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_total_weight_fields')) {

    function zc_pri_get_condition_type_total_weight_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'total_weight',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0.0',
                'placeholder' => __('0.0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
            ),
        );

        $fields['cart_total_weight'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-cart_total_weight', 'zc_pri_validate_condition_cart_total_weight', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_total_weight')) {

    function zc_pri_validate_condition_cart_total_weight($rule, $args) {
        $rule_total_weight = 0;
        if ($rule['total_weight'] != '') {
            $rule_total_weight = $rule['total_weight'];
        }

        $total_weight = WC()->cart->get_cart_contents_weight();

        return WooPricely_Validation_Util::validate_value($rule['compare'], $total_weight, $rule_total_weight, 'no');
    }

}