<?php

add_filter('zcpri/get-condition-type-group-cart', 'zc_pri_get_condition_type_total_quantity', 10, 2);
if (!function_exists('zc_pri_get_condition_type_total_quantity')) {

    function zc_pri_get_condition_type_total_quantity($list = array(), $args) {
        $list['cart_total_quantity'] = __('Cart Total Quantity','zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_total_quantity_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_total_quantity_fields')) {

    function zc_pri_get_condition_type_total_quantity_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'total_quantity',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['cart_total_quantity'] = $flds;
        return $fields;
    }

}



add_filter('zcpri/validate-condition-cart_total_quantity', 'zc_pri_validate_condition_cart_total_quantity', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_total_quantity')) {

    function zc_pri_validate_condition_cart_total_quantity($rule, $args) {
        $rule_total_quantity = 0;
        if ($rule['total_quantity'] != '') {
            $rule_total_quantity = $rule['total_quantity'];
        }

        $total_quantity = 0;
        foreach (WC()->cart->get_cart_item_quantities() as $key => $qty) {
            $total_quantity += $qty;
        }
        return WooPricely_Validation_Util::validate_value($rule['compare'], $total_quantity, $rule_total_quantity, 'no');
    }

}