<?php

add_filter('zcpri/get-condition-type-group-cart', 'zc_pri_get_condition_type_line_count', 10, 2);
if (!function_exists('zc_pri_get_condition_type_line_count')) {

    function zc_pri_get_condition_type_line_count($list = array(), $args) {
        $list['cart_line_count'] = __('Number Of Cart Items','zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_line_count_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_line_count_fields')) {

    function zc_pri_get_condition_type_line_count_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>=',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '99%',
                'box_width' => '44%',
            ),
            array(
                'id' => 'line_count',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '37%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );

        $fields['cart_line_count'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-cart_line_count', 'zc_pri_validate_condition_cart_line_count', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_line_count')) {

    function zc_pri_validate_condition_cart_line_count($rule, $args) {
        $rule_line_count = 0;
        if ($rule['line_count'] != '') {
            $rule_line_count = $rule['line_count'];
        }

        $line_count = 0;
        foreach (WC()->cart->get_cart_item_quantities() as $qty) {
            $line_count++;
        }

        return WooPricely_Validation_Util::validate_value($rule['compare'], $line_count, $rule_line_count, 'no');
    }

}