<?php

add_filter('zcpri/get-condition-type-group-cart_items', 'zc_pri_get_condition_type_cart_items_categories', 10, 2);
if (!function_exists('zc_pri_get_condition_type_cart_items_categories')) {

    function zc_pri_get_condition_type_cart_items_categories($list = array(), $args) {

        $list['cart_items_categories'] = __('Categories In Cart', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_cart_items_categories_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_cart_items_categories_fields')) {

    function zc_pri_get_condition_type_cart_items_categories_fields($fields, $args) {

        $fields['cart_items_categories'] = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in the list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in the list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'category_ids',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '100%',
                'box_width' => '56%',
            )
        );
        return $fields;
    }

}

add_filter('zcpri/validate-condition-cart_items_categories', 'zc_pri_validate_condition_cart_items_categories', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_items_categories')) {

    function zc_pri_validate_condition_cart_items_categories($rule, $args) {
        $category_ids = array();
        foreach (WooPricely::get_products_from_cart() as $product) {
            if (isset($product['categories'])) {
                foreach ($product['categories'] as $category_id) {
                    $category_ids[] = $category_id;
                }
            }
        }
        if (!is_array($rule['category_ids'])) {
            return false;
        }
        if (count($category_ids) == 0) {
            return false;
        }

        return WooPricely_Validation_Util::validate_list_list($category_ids, $rule['category_ids'], $rule['compare']);
    }

}
