<?php

add_filter('zcpri/get-condition-type-group-cart_items_quantity', 'zc_pri_get_condition_type_cart_items_quantity_categories', 10, 2);
if (!function_exists('zc_pri_get_condition_type_cart_items_quantity_categories')) {

    function zc_pri_get_condition_type_cart_items_quantity_categories($list = array(), $args) {
        $list['cart_items_qty_categories'] = __('Categories Quantity', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_cart_items_qty_categories_fields', 10, 2);
if (!function_exists('zc_pri_get_condition_type_cart_items_qty_categories_fields')) {

    function zc_pri_get_condition_type_cart_items_qty_categories_fields($fields, $args) {

        $fields['cart_items_qty_categories'] = array(
            array(
                'id' => 'category_ids',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Product categories...',
                'data' => 'categories:product_cat',
                'width' => '99%',
                'box_width' => '38%',
            ),
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => '>',
                'options' => array(
                    '>=' => __('More than or equal to', 'zc-woo-pricely'),
                    '>' => __('More than', 'zc-woo-pricely'),
                    '<=' => __('Less than or equal to', 'zc-woo-pricely'),
                    '<' => __('Less than', 'zc-woo-pricely'),
                    '==' => __('Equal to', 'zc-woo-pricely'),
                    '!=' => __('Not equal to', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '31%',
            ),
            array(
                'id' => 'quantity',
                'type' => 'textbox',
                'input_type' => 'number',
                'default' => '0',
                'placeholder' => __('0', 'zc-woo-pricely'),
                'width' => '100%',
                'box_width' => '12%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
        );
        return $fields;
    }

}

add_filter('zcpri/validate-condition-cart_items_qty_categories', 'zc_pri_validate_condition_cart_items_qty_categories', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_items_qty_categories')) {

    function zc_pri_validate_condition_cart_items_qty_categories($rule, $args) {
        if (!is_array($rule['category_ids'])) {
            return false;
        }
        $quantity = 0;
        foreach (WooPricely::get_products_from_cart() as $product) {
            if (WooPricely_Validation_Util::validate_list_list($product['categories'], $rule['category_ids'], 'in_list') != true) {
                continue;
            }
            if (isset($product['quantity'])) {
                $quantity += $product['quantity'];
            }
        }


        return WooPricely_Validation_Util::validate_value($rule['compare'], $quantity, $rule['quantity'], 'no');
    }

}