<?php

add_filter('zcpri/get-condition-type-group-cart', 'zc_pri_get_condition_type_coupons', 10, 2);
if (!function_exists('zc_pri_get_condition_type_coupons')) {

    function zc_pri_get_condition_type_coupons($list = array(), $args) {
        $list['cart_coupons'] = __('Applied Coupons','zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_cart_coupons_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_cart_coupons_fields')) {

    function zc_pri_get_condition_type_cart_coupons_fields($fields, $args) {

        
      
        $fields['cart_coupons'] = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'any' => __('Any list?', 'zc-woo-pricely'),
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'in_all_list' => __('All in the list', 'zc-woo-pricely'),
                    'in_list_only' => __('Only in the list', 'zc-woo-pricely'),
                    'in_all_list_only' => __('Only all in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'fold_id' => 'coupons_compare',
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'is_any',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'fold' => array(
                    'target' => 'coupons_compare',
                    'attribute' => 'value',
                    'value' => 'any',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '56%',
            ),
            array(
                'id' => 'applied_coupons',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Coupons...',
                'data' => 'posts:shop_coupon',
                'fold' => array(
                    'target' => 'coupons_compare',
                    'attribute' => 'value',
                    'value' => 'any',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'width' => '100%',
                'box_width' => '56%',
            )
        );
        return $fields;
    }

}


add_filter('zcpri/validate-condition-cart_coupons', 'zc_pri_validate_condition_cart_coupons', 10, 3);
if (!function_exists('zc_pri_validate_condition_cart_coupons')) {

    function zc_pri_validate_condition_cart_coupons($rule, $args) {
        $applied_coupons = WooPricelyUtil::get_applied_coupons_ids();

        if ($rule['compare'] == 'any') {
            
            return WooPricely_Validation_Util::validate_list_empty($applied_coupons, $rule['is_any']);
        } else {
            
            if (!is_array($rule['applied_coupons'])) {
                return false;
            }

            return WooPricely_Validation_Util::validate_list_list($applied_coupons, $rule['applied_coupons'], $rule['compare']);
        }
    }

}