<?php

add_filter('zcpri/get-condition-type-group-date_time', 'zc_pri_get_condition_type_calendar_months_of_year', 10, 2);
if (!function_exists('zc_pri_get_condition_type_calendar_months_of_year')) {

    function zc_pri_get_condition_type_calendar_months_of_year($list = array(), $args) {
        $list['calendar_months_of_year'] = __('Months Of Year', 'zc-woo-pricely');
        return $list;
    }

}


add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_calendar_months_of_year_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_calendar_months_of_year_fields')) {

    function zc_pri_get_condition_type_calendar_months_of_year_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'months',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Months...',
                'allow_clear' => true,
                'options' => array(
                    '1' => __('January', 'zc-woo-pricely'),
                    '2' => __('February', 'zc-woo-pricely'),
                    '3' => __('March', 'zc-woo-pricely'),
                    '4' => __('April', 'zc-woo-pricely'),
                    '5' => __('May', 'zc-woo-pricely'),
                    '6' => __('June', 'zc-woo-pricely'),
                    '7' => __('July', 'zc-woo-pricely'),
                    '8' => __('August', 'zc-woo-pricely'),
                    '9' => __('September', 'zc-woo-pricely'),
                    '10' => __('October', 'zc-woo-pricely'),
                    '11' => __('November', 'zc-woo-pricely'),
                    '12' => __('December', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'box_width' => '56%',
            )
        );


        $fields['calendar_months_of_year'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-calendar_months_of_year', 'zc_pri_validate_condition_calendar_months_of_year', 10, 3);
if (!function_exists('zc_pri_validate_condition_calendar_months_of_year')) {

    function zc_pri_validate_condition_calendar_months_of_year($rule, $args) {

        if (!is_array($rule['months'])) {
            return false;
        }

        $date_range = WooPricelyUtil::get_date_from_year_months($rule['compare'], $rule['months']);
        if ($date_range == '') {
            return false;
        }
        $current_date_time = WooPricelyUtil::get_current_date(true);

        $from_is_valid = WooPricely_Validation_Util::validate_date('>=', $current_date_time, $date_range['from'], 'Y-m-d H:i:s', 'Y-m-d H:i:s');
        $to_is_valid = WooPricely_Validation_Util::validate_date('<=', $current_date_time, $date_range['to'], 'Y-m-d H:i:s', 'Y-m-d H:i:s');

        $is_valid = ($from_is_valid == true && $to_is_valid == true);

        if ($is_valid == true) {
            WooPricely_CountDown::set_datetime($date_range['to']);
        }
        return $is_valid;
    }

}