<?php

add_filter('zcpri/get-condition-type-group-date_time', 'zc_pri_get_condition_type_calendar_days_of_week', 10, 2);
if (!function_exists('zc_pri_get_condition_type_calendar_days_of_week')) {

    function zc_pri_get_condition_type_calendar_days_of_week($list = array(), $args) {
        $list['calendar_days_of_week'] = __('Days Of Week', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_calendar_days_of_week_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_calendar_days_of_week_fields')) {

    function zc_pri_get_condition_type_calendar_days_of_week_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%'
            ),
            array(
                'id' => 'days',
                'type' => 'select2',
                'multiple' => true,
                'placeholder' => 'Days of week...',
                'allow_clear' => true,
                'options' => array(
                    '0' => __('Monday', 'zc-woo-pricely'),
                    '1' => __('Tuesday', 'zc-woo-pricely'),
                    '2' => __('Wednesday', 'zc-woo-pricely'),
                    '3' => __('Thursday', 'zc-woo-pricely'),
                    '4' => __('Friday', 'zc-woo-pricely'),
                    '5' => __('Saturday', 'zc-woo-pricely'),
                    '6' => __('Sunday', 'zc-woo-pricely'),
                ),
                'width' => '100%',
                'box_width' => '56%',
            )
        );


        $fields['calendar_days_of_week'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-calendar_days_of_week', 'zc_pri_validate_condition_calendar_days_of_week', 10, 3);
if (!function_exists('zc_pri_validate_condition_calendar_days_of_week')) {

    function zc_pri_validate_condition_calendar_days_of_week($rule, $args) {
        if (!is_array($rule['days'])) {
            return false;
        }

        $range = WooPricelyUtil::get_date_from_week_days($rule['compare'], $rule['days']);
        if ($range == '') {
            return false;
        }
        $current_date_time = WooPricelyUtil::get_current_date(true);

        $from_is_valid = WooPricely_Validation_Util::validate_date('>=', $current_date_time, $range['from'], 'Y-m-d H:i:s', 'Y-m-d H:i:s');
        $to_is_valid = WooPricely_Validation_Util::validate_date('<=', $current_date_time, $range['to'], 'Y-m-d H:i:s', 'Y-m-d H:i:s');

        $is_valid = ($from_is_valid == true && $to_is_valid == true);

        if ($is_valid == true) {
            WooPricely_CountDown::set_datetime($range['to']);
        }

        return $is_valid;
    }

}