<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_billing_state', 10, 2);
if (!function_exists('zc_pri_get_condition_type_billing_state')) {

    function zc_pri_get_condition_type_billing_state($list = array(), $args) {
        $list['billing_state'] = __('Billing State', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_billing_state_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_billing_state_fields')) {

    function zc_pri_get_condition_type_billing_state_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'billing_states',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'minimum_input_length' => 2,
                'minimum_results_forsearch' => 10,
                'placeholder' => __('Billing States...', 'zc-woo-pricely'),
                'ajax_data' => 'wc:states',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['billing_state'] = $flds;
        return $fields;
    }

}



add_filter('zcpri/validate-condition-billing_state', 'zc_pri_validate_condition_billing_state', 10, 3);
if (!function_exists('zc_pri_validate_condition_billing_state')) {

    function zc_pri_validate_condition_billing_state($rule, $args) {

        if (!is_array($rule['billing_states'])) {
            return false;
        }

        $billing_country = WC()->customer->get_billing_country(false);
        $billing_state = $billing_country . ':' . WC()->customer->get_billing_state(false);
        return WooPricely_Validation_Util::validate_value_list($billing_state, $rule['billing_states'], $rule['compare']);
    }

}