<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_payment_method', 10, 2);
if (!function_exists('zc_pri_get_condition_type_payment_method')) {

    function zc_pri_get_condition_type_payment_method($list = array(), $args) {
        $list['payment_method'] = __('Payment Method', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_payment_method_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_payment_method_fields')) {

    function zc_pri_get_condition_type_payment_method_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'payment_methods',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'placeholder' => __('Payment methods...', 'zc-woo-pricely'),
                'data' => 'wc:payment_methods',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['payment_method'] = $flds;
        return $fields;
    }

}


add_filter('zcpri/validate-condition-payment_method', 'zc_pri_validate_condition_payment_method', 10, 3);
if (!function_exists('zc_pri_validate_condition_payment_method')) {

    function zc_pri_validate_condition_payment_method($rule, $args) {
        if (!is_array($rule['payment_methods'])) {
            return false;
        }

        $chosen_gateway = WC()->session->chosen_payment_method;
        return WooPricely_Validation_Util::validate_value_list($chosen_gateway, $rule['payment_methods'], $rule['compare']);
    }

}




