<?php

add_filter('zcpri/get-condition-type-group-billing_shipping', 'zc_pri_get_condition_type_billing_country', 10, 2);
if (!function_exists('zc_pri_get_condition_type_billing_country')) {

    function zc_pri_get_condition_type_billing_country($list = array(), $args) {
        $list['billing_country'] = __('Billing Country', 'zc-woo-pricely');
        return $list;
    }

}

add_filter('zcpri/get-condition-type-fields', 'zc_pri_get_condition_type_billing_country_fields', 10, 2);

if (!function_exists('zc_pri_get_condition_type_billing_country_fields')) {

    function zc_pri_get_condition_type_billing_country_fields($fields, $args) {

        $flds = array(
            array(
                'id' => 'compare',
                'type' => 'select2',
                'default' => 'in_list',
                'options' => array(
                    'in_list' => __('Any in the list', 'zc-woo-pricely'),
                    'none' => __('None in the list', 'zc-woo-pricely'),
                ),
                'width' => '98%',
                'box_width' => '25%',
            ),
            array(
                'id' => 'billing_countries',
                'type' => 'select2',
                'multiple' => true,
                'allow_clear' => true,
                'minimum_input_length' => 2,
                'minimum_results_forsearch' => 10,
                'placeholder' => __('Billing Countries...', 'zc-woo-pricely'),
                'ajax_data' => 'wc:countries',
                'width' => '100%',
                'box_width' => '56%',
            )
        );

        $fields['billing_country'] = $flds;
        return $fields;
    }

}

add_filter('zcpri/validate-condition-billing_country', 'zc_pri_validate_condition_billing_country', 10, 3);
if (!function_exists('zc_pri_validate_condition_billing_country')) {

    function zc_pri_validate_condition_billing_country($rule, $args) {
        if (!is_array($rule['billing_countries'])) {
            return false;
        }
        $billing_country = WC()->customer->get_billing_country(false);
        return WooPricely_Validation_Util::validate_value_list($billing_country, $rule['billing_countries'], $rule['compare']);
    }

}
