<?php

add_filter('reon/get-repeater-field-products_pricing_rules-templates', 'zc_pri_get_products_pricing_rules_template', 10, 2);

function zc_pri_get_products_pricing_rules_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {
        $in_templates[] = array(
            'id' => 'price_rule',
            'head' => array(
                'title' => '',
                'defaut_title' => __('Product Pricing', 'zc-woo-pricely'),
                'title_field' => 'admin_note',
                'subtitle_field' => 'price_mode',
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-products_pricing_rules-price_rule-fields', 'zc_pri_get_products_price_rule_template_fields', 10, 2);

function zc_pri_get_products_price_rule_template_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'rule_opt',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'last' => true,        
        'fields' => array(
            array(
                'id' => 'any_ids',
                'type' => 'columns-field',
                'columns' => 5,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'price_mode',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Mode', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the products pricing mode, you can choose either Regular Price Adjustment, Sale Price Adjustment or Regular / Sale Price Adjustment', 'zc-woo-pricely'),
                        'default' => 'before_add_to_cart',
                        'options' => array(
                            'sale_price' => __('Sale Price Adjusment', 'zc-woo-pricely'),
                            'regular_price' => __('Regular Price Adjusment', 'zc-woo-pricely'),
                            'regular_sale_price' => __('Regular / Sale Price Adjusment', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold_id' => 'price_mode',
                    ),
                    array(
                        'id' => 'admin_note',
                        'type' => 'textbox',
                        'tooltip' => __('Adds a private note for reference purposes', 'zc-woo-pricely'),
                        'column_size' => 2,
                        'column_title' => __('Admin Note', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'clear_sale_price',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Clear Sale Price', 'zc-woo-pricely'),
                        'tooltip' => __('Clears sale prices on applied products', 'zc-woo-pricely'),
                        'default' => 'no',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'price_mode',
                            'attribute' => 'value',
                            'value' => 'regular_price',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                ),
            ),
            array(
                'id' => 'regular_adj',
                'type' => 'columns-field',
                'columns' => 5,
                'fold' => array(
                    'target' => 'price_mode',
                    'attribute' => 'value',
                    'value' => 'sale_price',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'adjustment',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Regular Price Adjustment', 'zc-woo-pricely'),
                        'tooltip' => __('Controls regular pricing adjustment method on applied products', 'zc-woo-pricely'),
                        'options' => array(
                            'fixed_price' => __('Fixed price', 'zc-woo-pricely'),
                            'fixed_discount' => __('Fixed discount amount', 'zc-woo-pricely'),
                            'fixed_fee' => __('Fixed fee amount', 'zc-woo-pricely'),
                            'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
                            'per_fee' => __('Percentage fee', 'zc-woo-pricely'),
                        ),
                        'default' => 'fixed_discount',
                        'width' => '100%',
                        'fold_id' => 'reg_adj',
                    ),
                    array(
                        'id' => 'base_on',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Base On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how to calculate the product prices, calculations can be based on product regular price, sale price or previously calculated prices', 'zc-woo-pricely'),
                        'options' => array(
                            'product' => array(
                                'label' => __('Source Prices', 'zc-woo-pricely'),
                                'options' => array(
                                    'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                                    'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                                ),
                            ),
                            'calc' => array(
                                'label' => __('Computed Prices', 'zc-woo-pricely'),
                                'options' => array(
                                    'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                                    'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                                ),
                            ),
                        ),
                        'default' => 'reg_price',
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'reg_adj',
                            'attribute' => 'value',
                            'value' => 'fixed_price',
                            'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'amount',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Amount', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the amount to apply based on the Regular Price Adjustment method', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '0.01',
                        ),
                    ),
                ),
            ),
            array(
                'id' => 'sale_adj',
                'type' => 'columns-field',
                'columns' => 5,
                'fold' => array(
                    'target' => 'price_mode',
                    'attribute' => 'value',
                    'value' => 'regular_price',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'adjustment',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Sale Price Adjustment', 'zc-woo-pricely'),
                        'tooltip' => __('Controls sale pricing adjustment method on applied products', 'zc-woo-pricely'),
                        'options' => array(
                            'fixed_price' => __('Fixed price', 'zc-woo-pricely'),
                            'fixed_discount' => __('Fixed discount amount', 'zc-woo-pricely'),
                            'fixed_fee' => __('Fixed fee amount', 'zc-woo-pricely'),
                            'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
                            'per_fee' => __('Percentage fee', 'zc-woo-pricely'),
                        ),
                        'default' => 'reg_price',
                        'width' => '100%',
                        'fold_id' => 'sale_adj',
                    ),
                    array(
                        'id' => 'base_on',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Base On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how to calculate the product prices, calculations can be based on product regular price, sale price or previously calculated prices', 'zc-woo-pricely'),
                        'options' => array(
                            'product' => array(
                                'label' => __('Source Prices', 'zc-woo-pricely'),
                                'options' => array(
                                    'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                                    'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                                ),
                            ),
                            'calc' => array(
                                'label' => __('Computed Prices', 'zc-woo-pricely'),
                                'options' => array(
                                    'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                                    'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                                ),
                            ),
                        ),
                        'default' => 'reg_price',
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'sale_adj',
                            'attribute' => 'value',
                            'value' => 'fixed_price',
                            'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'amount',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Amount', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the amount to apply based on the Sale Price Adjustment method', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '0.01',
                        ),
                    ),
                ),
            ),
            array(
                'id' => 'schedule_sale',
                'type' => 'columns-field',
                'columns' => 4,
                'fold' => array(
                    'target' => 'price_mode',
                    'attribute' => 'value',
                    'value' => 'regular_price',
                    'oparator' => 'neq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'enable',
                        'type' => 'select2',
                        'column_size' => 2,
                        'column_title' => __('Schedule Sale Price', 'zc-woo-pricely'),
                        'tooltip' => __("Controls product sale schedule dates, work like WooCommerce schedule sale dates, enabling this option allows you to set the 'From' and 'To' date", 'zc-woo-pricely'),
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'default' => 'no',
                        'width' => '100%',
                        'fold_id' => 'schedule_price',
                    ),
                    array(
                        'id' => 'from',
                        'type' => 'date',
                        'column_size' => 1,
                        'column_title' => __('From', 'zc-woo-pricely'),
                        'tooltip' => __('Controls product sale schedule from date', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => 'YYYY-MM-DD',
                        'date_format' => 'yy-mm-dd',
                        'number_of_months' => 1,
                        'show_button_panel' => false,
                        'change_month' => true,
                        'change_year' => true,
                        'show_week' => true,

                        'show_other_months' => true,
                        'select_other_months' => true,

                        'width' => '100%',
                        'fold' => array(
                            'target' => 'schedule_price',
                            'attribute' => 'value',
                            'value' => 'yes',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'to',
                        'type' => 'date',
                        'column_size' => 1,
                        'column_title' => __('To', 'zc-woo-pricely'),
                        'tooltip' => __('Controls product sale schedule to date', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => 'YYYY-MM-DD',
                        'date_format' => 'yy-mm-dd',
                        'number_of_months' => 1,
                        'show_button_panel' => false,
                        'change_month' => true,
                        'change_year' => true,
                        'show_week' => true,

                        'show_other_months' => true,
                        'select_other_months' => true,

                        'width' => '100%',
                        'fold' => array(
                            'target' => 'schedule_price',
                            'attribute' => 'value',
                            'value' => 'yes',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                ),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 2,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'message',
                        'type' => 'textbox',
                        'column_size' => 2,
                        'column_title' => __('Promo Message', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the promotional message on single product page', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                ),
            ),
            array(
                'id' => 'products',
                'type' => 'simple-repeater',
                'filter_id' => 'shop_price_products',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Product Filters', 'zc-woo-pricely'),
                'desc' => __('List of product filters, empty filters will include all products', 'zc-woo-pricely'),
                'white_repeater' => false,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'sortable' => array(
                    'enabled' => true,
                ),
                'template_adder' => array(
                    'position' => 'right', //left, right
                    'show_list' => false,
                    'button_text' => __('Add Filter', 'zc-woo-pricely'),
                ),
            ),
        ),
    );

    $in_fields[] = array(
        'id' => 'condidions',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'conditions',
                'type' => 'simple-repeater',
                'filter_id' => 'shop_price_conditions',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Conditions', 'zc-woo-pricely'),
                'desc' => __('List of conditions in which this rule should apply, empty conditions will apply in all cases', 'zc-woo-pricely'),
                'white_repeater' => false,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'sortable' => array(
                    'enabled' => true,
                ),
                'template_adder' => array(
                    'position' => 'right', //left, right
                    'show_list' => false,
                    'button_text' => __('Add Condition', 'zc-woo-pricely'),
                ),
            ),
        ),
    );

    return $in_fields;
}

add_filter('roen/get-repeater-template-products_pricing_rules-price_rule-head-fields', 'zc_pri_get_products_price_rule_template_head_fields', 10, 2);

function zc_pri_get_products_price_rule_template_head_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'group-field',
        'position' => 'right',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'apply_mode',
                'type' => 'select2',
                'default' => 'with_others',
                'options' => array(
                    'with_others' => __('Apply this and other rules (per product)', 'zc-woo-pricely'),
                    'only_this' => __('Apply only this rule (per product)', 'zc-woo-pricely'),
                    'if_others' => __('Apply if other rules are valid (per product)', 'zc-woo-pricely'),
                    'if_no_others' => __('Apply if no other valid rules (per product)', 'zc-woo-pricely'),
                ),
                'width' => '290px',
            ),
            array(
                'id' => 'enable',
                'type' => 'select2',
                'default' => 'yes',
                'options' => array(
                    'yes' => __('Enable', 'zc-woo-pricely'),
                    'no' => __('Disable', 'zc-woo-pricely'),
                ),
                'width' => '95px',
            ),
        ),
    );

    return $in_fields;
}
