<?php

require_once (dirname(__FILE__) . '/rules-template-simple.php');
require_once (dirname(__FILE__) . '/rules-template-bulk.php');
require_once (dirname(__FILE__) . '/rules-template-group.php');
require_once (dirname(__FILE__) . '/rules-template-bogo.php');

add_filter('reon/get-repeater-field-checkout_price_rules-templates', 'zc_pri_get_checkout_price_rules_template', 10, 2);

function zc_pri_get_checkout_price_rules_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {
        $in_templates[] = array(
            'id' => 'price_rule',
            'head' => array(
                'title' => '',
                'defaut_title' => __('Checkout Pricing', 'zc-woo-pricely'),
                'title_field' => 'admin_note',
                'subtitle_field' => 'mode',
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-checkout_price_rules-price_rule-fields', 'zc_pri_get_checkout_price_rule_template_fields', 10, 2);

function zc_pri_get_checkout_price_rule_template_fields($in_fields, $args) {

    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'last' => true,
        'merge_fields' => false,
        'fields' => apply_filters('zcpri/get-checkout-prices-settings-fields', array(
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 3,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'mode',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Mode', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the checkout pricing mode', 'zc-woo-pricely'),
                        'default' => 'simple',
                        'options' => apply_filters('zcpri/get-checkout-prices-settings-modes', array(
                            'simple' => __('Simple Discount Pricing', 'zc-woo-pricely'),
                            'bulk' => __('Bulk Discount Pricing', 'zc-woo-pricely'),
                            'tiered' => __('Tiered Discount Pricing', 'zc-woo-pricely'),
                            'products_group' => __('Products Group Pricing', 'zc-woo-pricely'),
                            'buy_x_get_x' => __('Buy x Get x Pricing', 'zc-woo-pricely'),
                            'buy_x_get_y' => __('Buy x Get y Pricing', 'zc-woo-pricely'),
                        )),
                        'width' => '100%',
                        'fold_id' => 'price_mode',
                    ),
                    array(
                        'id' => 'qty_base_on',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Quantities Based On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how to count cart item quantities', 'zc-woo-pricely'),
                        'options' => apply_filters('zcpri/get-checkout-prices-settings-quantity-based-on-options', array(
                            'product_id' => __('Product ID', 'zc-woo-pricely'),
                            'variation_id' => __('Product Variations', 'zc-woo-pricely'),
                            'category_id' => __('Product Categories', 'zc-woo-pricely'),
                            'cart_key' => __('Cart Line Items', 'zc-woo-pricely'),
                            'cart' => __('All Cart Items', 'zc-woo-pricely'),
                        )),
                        'default' => 'product_id',
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'price_mode',
                            'attribute' => 'value',
                            'value' => apply_filters('zcpri/get-checkout-prices-settings-quantity-based-on-folds', array('bulk', 'tiered', 'products_group', 'buy_x_get_x', 'buy_x_get_y')),
                            'oparator' => 'eq',
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'admin_note',
                        'type' => 'textbox',
                        'tooltip' => __('Adds a private note for reference purposes', 'zc-woo-pricely'),
                        'column_size' => 1,
                        'column_title' => __('Admin Note', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                ),
            ),
                )//end fields
        )
    );

    $in_fields[] = array(
        'id' => 'conditions',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'conditions',
                'type' => 'simple-repeater',
                'filter_id' => 'checkout_price_conditions',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Conditions', 'zc-woo-pricely'),
                'desc' => __('List of conditions in which this rule should apply, empty conditions will apply in all cases', 'zc-woo-pricely'),
                'white_repeater' => false,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'sortable' => array(
                    'enabled' => true,
                ),
                'template_adder' => array(
                    'position' => 'right',
                    'show_list' => false,
                    'button_text' => __('Add Condition', 'zc-woo-pricely'),
                ),
            ),
        ),
    );

    return $in_fields;
}

add_filter('roen/get-repeater-template-checkout_price_rules-price_rule-head-fields', 'zc_pri_get_checkout_price_rule_template_head_fields', 10, 2);

function zc_pri_get_checkout_price_rule_template_head_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'group-field',
        'position' => 'right',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'apply_mode',
                'type' => 'select2',
                'default' => 'with_others',
                'options' => array(
                    'with_others' => __('Apply this and other rules', 'zc-woo-pricely'),
                    'only_this' => __('Apply only this rule', 'zc-woo-pricely'),
                    'if_others' => __('Apply if other rules are valid', 'zc-woo-pricely'),
                    'if_no_others' => __('Apply if no other valid rules', 'zc-woo-pricely'),
                ),
                'width' => '210px',
            ),
            array(
                'id' => 'enable',
                'type' => 'select2',
                'default' => 'yes',
                'options' => array(
                    'yes' => __('Enable', 'zc-woo-pricely'),
                    'no' => __('Disable', 'zc-woo-pricely'),
                ),
                'width' => '95px',
            ),
        ),
    );

    return $in_fields;
}
