<?php

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_simple', 20);

function zc_pri_get_checkout_price_rule_template_fields_simple($in_fields) {
    $in_fields[] = array(
        'id' => 'simple_discount',
        'type' => 'columns-field',
        'columns' => 5,
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('simple'),
            'oparator' => 'eq',
            'clear' => true,
        ),
        'fields' => array(
            array(
                'id' => 'discount_type',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Discount Type', 'zc-woo-pricely'),
                'tooltip' => __('Controls discount amount type', 'zc-woo-pricely'),
                'options' => array(
                    'free' => __('Free', 'zc-woo-pricely'),
                    'fixed_price' => __('Fixed price', 'zc-woo-pricely'),
                    'fixed_price_unit' => __('Fixed price per unit', 'zc-woo-pricely'),
                    'fixed_discount' => __('Fixed discount amount', 'zc-woo-pricely'),
                    'fixed_discount_unit' => __('Fixed discount amount per unit', 'zc-woo-pricely'),
                    'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
                ),
                'default' => 'fixed_discount',
                'width' => '100%',
                'fold_id' => 'discount_type',
            ),
            array(
                'id' => 'base_on',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Base On', 'zc-woo-pricely'),
                'tooltip' => __('Controls how to calculate the simple discount pricing', 'zc-woo-pricely'),
                'options' => array(
                    'cart_price' => __('Cart item price', 'zc-woo-pricely'),
                    'product' => array(
                        'label' => 'Source Prices',
                        'options' => array(
                            'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                            'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                        ),
                    ),
                    'calc' => array(
                        'label' => 'Computed Prices',
                        'options' => array(
                            'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                            'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                        ),
                    ),
                ),
                'default' => 'cart_price',
                'width' => '100%',
                'fold' => array(
                    'target' => 'discount_type',
                    'attribute' => 'value',
                    'value' => array('fixed_discount', 'fixed_discount_unit', 'per_discount'),
                    'oparator' => 'eq',
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'amount',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 1,
                'column_title' => __('Amount', 'zc-woo-pricely'),
                'tooltip' => __('Controls the amount to apply based on the Discount Type method', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
                'fold' => array(
                    'target' => 'discount_type',
                    'attribute' => 'value',
                    'value' => 'free',
                    'oparator' => 'neq',
                    'clear' => true,
                ),
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_messages', 60);

function zc_pri_get_checkout_price_rule_template_fields_messages($in_fields) {
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'columns-field',
        'columns' => 1,
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'message',
                'type' => 'textbox',
                'column_size' => 1,
                'column_title' => __('Promo Message', 'zc-woo-pricely'),
                'tooltip' => __('Controls the promotional message on single product page', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('Type here...', 'zc-woo-pricely'),
                'width' => '100%',
            ),
        )
    );
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'columns-field',
        'columns' => 1,
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'notification',
                'type' => 'textbox',
                'column_size' => 1,
                'column_title' => __('Cart/Checkout Notification', 'zc-woo-pricely'),
                'tooltip' => __('Controls the notification message on cart and checkout pages', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('Type here...', 'zc-woo-pricely'),
                'width' => '100%',
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_product_filters', 100);

function zc_pri_get_checkout_price_rule_template_fields_product_filters($in_fields) {
    $in_fields[] = array(
        'id' => 'products',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_products',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Product Filters', 'zc-woo-pricely'),
        'desc' => __('List of product filters, empty filters will include all products', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'sortable' => array(
            'enabled' => true,
        ),
        'template_adder' => array(
            'position' => 'right',
            'show_list' => false,
            'button_text' => __('Add Filter', 'zc-woo-pricely'),
        ),
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => apply_filters('zcpri/get-checkout-prices-settings-product-filters-folds', array('simple', 'bulk', 'tiered', 'buy_x_get_x')),
            'oparator' => 'eq',
            'clear' => true,
        ),
    );
    return $in_fields;
}

add_filter('zcpri/sanitize-checkout-prices-simple-rule-settings', 'sanitize_zc_pri_checkout_prices_simple_options');

function sanitize_zc_pri_checkout_prices_simple_options($rule) {
    $rl = array();
    
    if (isset($rule['simple_discount'])) {
        $rl['simple_discount'] = $rule['simple_discount'];
    }

    if (isset($rule['products'])) {
        $rl['products'] = $rule['products'];
    }

    return $rl;
}
