<?php

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_group_discount', 40);

function zc_pri_get_checkout_price_rule_template_fields_group_discount($in_fields) {
    $in_fields[] = array(
        'id' => 'group_discount',
        'type' => 'columns-field',
        'columns' => 6,
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => 'products_group',
            'oparator' => 'eq',
            'clear' => true,
        ),
        'fields' => array(
            array(
                'id' => 'discount_type',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Discount Type', 'zc-woo-pricely'),
                'tooltip' => __('Controls discount amount type', 'zc-woo-pricely'),
                'options' => array(
                    'free' => __('Free', 'zc-woo-pricely'),
                    'fixed_price_unit' => __('Fixed price per item', 'zc-woo-pricely'),
                    'fixed_group_price' => __('Fixed price per group', 'zc-woo-pricely'),
                    'fixed_discount_unit' => __('Fixed discount per item', 'zc-woo-pricely'),
                    'fixed_group_discount' => __('Fixed discount per group', 'zc-woo-pricely'),
                    'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
                ),
                'default' => 'fixed_price_unit',
                'width' => '100%',
                'fold_id' => 'group_discount_type',
            ),
            array(
                'id' => 'base_on',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Base On', 'zc-woo-pricely'),
                'tooltip' => __('Controls how to calculate the products group discount pricing', 'zc-woo-pricely'),
                'options' => array(
                    'cart_price' => __('Cart item price', 'zc-woo-pricely'),
                    'product' => array(
                        'label' => 'Source Prices',
                        'options' => array(
                            'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                            'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                        ),
                    ),
                    'calc' => array(
                        'label' => 'Computed Prices',
                        'options' => array(
                            'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                            'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                        ),
                    ),
                ),
                'default' => 'cart_price',
                'width' => '100%',
                'fold' => array(
                    'target' => 'group_discount_type',
                    'attribute' => 'value',
                    'value' => array('fixed_discount', 'fixed_group_discount', 'per_discount', 'per_group_discount'),
                    'oparator' => 'eq',
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'amount',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 1,
                'column_title' => __('Amount', 'zc-woo-pricely'),
                'tooltip' => __('Controls the amount to apply based on the Discount Type method', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
                'fold' => array(
                    'target' => 'group_discount_type',
                    'attribute' => 'value',
                    'value' => 'free',
                    'oparator' => 'neq',
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'repeat',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Repeating', 'zc-woo-pricely'),
                'tooltip' => __('Allows group discount pricing to apply discounts more than once', 'zc-woo-pricely'),
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'default' => 'no',
                'width' => '100%',
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_products_in_group', 90);

function zc_pri_get_checkout_price_rule_template_fields_products_in_group($in_fields) {
    $in_fields[] = array(
        'id' => 'products_in_group',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_products_in_group',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Products In Group', 'zc-woo-pricely'),
        'desc' => __('List of group product filters, empty filters will not include any product', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => 'products_group',
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
        'default' => array(array('qty' => 2, 'rule_type' => 'products')),
        'sortable' => array(
            'enabled' => false,
        ),
        'template_adder' => array(
            'position' => 'right', //left, right
            'show_list' => false,
            'button_text' => __('Add Filter', 'zc-woo-pricely'),
        ),
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_group_product_rules', 110);

function zc_pri_get_checkout_price_rule_template_fields_group_product_rules($in_fields) {
    $in_fields[] = array(
        'id' => 'group_product_rules',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_products',
        'full_width' => true,
        'center_head' => true,
        'last' => true,
        'title' => __('Other Product Filters', 'zc-woo-pricely'),
        'desc' => __('List of product filters, empty filters will not include any product', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'sortable' => array(
            'enabled' => true,
        ),
        'template_adder' => array(
            'position' => 'right', //left, right
            'show_list' => false,
            'button_text' => __('Add Rule', 'zc-woo-pricely'),
        ),
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('products_group'),
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
    );
    return $in_fields;
}

add_filter('zcpri/sanitize-checkout-prices-products_group-rule-settings', 'sanitize_zc_pri_checkout_prices_products_group_options');

function sanitize_zc_pri_checkout_prices_products_group_options($rule) {
    $rl = array();

    if (isset($rule['qty_base_on'])) {
        $rl['qty_base_on'] = $rule['qty_base_on'];
    }

    if (isset($rule['group_discount'])) {
        $rl['group_discount'] = $rule['group_discount'];
    }
    
    if (isset($rule['products_in_group'])) {
        $rl['products_in_group'] = $rule['products_in_group'];
    }
    
    if (isset($rule['group_product_rules'])) {
        $rl['group_product_rules'] = $rule['group_product_rules'];
    }

    return $rl;
}
