<?php

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_range_discount', 50);

function zc_pri_get_checkout_price_rule_template_fields_range_discount($in_fields) {
    $in_fields[] = array(
        'id' => 'range_discount',
        'type' => 'columns-field',
        'columns' => 2,
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('bulk', 'tiered'),
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
        'fields' => array(
            array(
                'id' => 'base_on',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Range Discounts Base On', 'zc-woo-pricely'),
                'tooltip' => __('Controls how to calculate the range discount pricing', 'zc-woo-pricely'),
                'options' => array(
                    'cart_price' => __('Cart item price', 'zc-woo-pricely'),
                    'product' => array(
                        'label' => 'Source Prices',
                        'options' => array(
                            'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                            'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                        ),
                    ),
                    'calc' => array(
                        'label' => 'Computed Prices',
                        'options' => array(
                            'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                            'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                        ),
                    ),
                ),
                'default' => 'cart_price',
                'width' => '100%',
            ),
            array(
                'id' => 'metrics_table',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Metrics Table', 'zc-woo-pricely'),
                'tooltip' => __('Controls the metric tables to display on single product page', 'zc-woo-pricely'),
                'ajax_data' => 'dpd:metrics_table',
                'default' => 'table_0',
                'placeholder' => __('Select group', 'zc-woo-pricely'),
                'width' => '100%',
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_quantity_ranges', 80);

function zc_pri_get_checkout_price_rule_template_fields_quantity_ranges($in_fields) {
    $in_fields[] = array(
        'id' => 'quantity_ranges',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_quantity_ranges',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Quantity Ranges', 'zc-woo-pricely'),
        'desc' => __('Controls quantity range discounts pricing', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('bulk', 'tiered'),
            'oparator' => 'eq',
            'clear' => true,
        ),
        'default' => array(array('min' => 1, 'max' => 5)),
        'sortable' => array(
            'enabled' => false,
        ),
        'head' => array(
            'enable' => true,
            'enable_footer' => true,
            'titles' => array(
                array('offset' => '10px', 'text' => __('Minimum', 'zc-woo-pricely'), 'width' => '19.333%', 'tooltip' => "Controls quantity range's minimum quantity"),
                array('text' => __('Maximum', 'zc-woo-pricely'), 'width' => '18.9%', 'tooltip' => "Controls quantity range's minimum quantity"),
                array('text' => __('Discount Type', 'zc-woo-pricely'), 'width' => '34.8%', 'tooltip' => "Controls quantity range's discount type"),
                array('text' => __('Amount', 'zc-woo-pricely'), 'width' => '22%', 'tooltip' => "Controls quantity range's discount amount"),
            ),
        ),
        'template_adder' => array(
            'position' => 'right',
            'show_list' => false,
            'button_text' => __('Add Quantity Range', 'zc-woo-pricely'),
        ),
    );
    return $in_fields;
}

add_filter('zcpri/sanitize-checkout-prices-bulk-rule-settings', 'sanitize_zc_pri_checkout_prices_bulk_options');
add_filter('zcpri/sanitize-checkout-prices-tiered-rule-settings', 'sanitize_zc_pri_checkout_prices_bulk_options');

function sanitize_zc_pri_checkout_prices_bulk_options($rule) {
    $rl = array();
    if (isset($rule['qty_base_on'])) {
        $rl['qty_base_on'] = $rule['qty_base_on'];
    }

    if (isset($rule['range_discount'])) {
        $rl['range_discount'] = $rule['range_discount'];
    }

    if (isset($rule['quantity_ranges'])) {
        $rl['quantity_ranges'] = $rule['quantity_ranges'];
    }

    if (isset($rule['products'])) {
        $rl['products'] = $rule['products'];
    }

    return $rl;
}
