<?php

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_bogo_qty', 10);

function zc_pri_get_checkout_price_rule_template_fields_bogo_qty($in_fields) {
    $in_fields[] = array(
        'id' => 'bogo_qty',
        'type' => 'columns-field',
        'columns' => 5,
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('buy_x_get_x', 'buy_x_get_y'),
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
        'fields' => array(
            array(
                'id' => 'purchase_qty',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 2,
                'column_title' => __('Purchased Quantity', 'zc-woo-pricely'),
                'tooltip' => __('Controls the minimum product quantity for the discount to apply', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('Quantity', 'zc-woo-pricely'),
                'width' => '100%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
            array(
                'id' => 'discount_qty',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 2,
                'column_title' => __('Received Quantity', 'zc-woo-pricely'),
                'tooltip' => __('Controls the total number of products to apply the discount to', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('Quantity', 'zc-woo-pricely'),
                'width' => '100%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '1',
                ),
            ),
            array(
                'id' => 'auto_add',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Auto Add', 'zc-woo-pricely'),
                'tooltip' => __('Automatically adds more discounted products if quantity is less than Received Quantity', 'zc-woo-pricely'),
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'default' => 'no',
                'width' => '100%',
                'fold' => array(
                    'target' => 'price_mode',
                    'attribute' => 'value',
                    'value' => array('buy_x_get_y'),
                    'oparator' => 'eq',
                    'clear' => true,
                ),
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_bogo_discount', 30);

function zc_pri_get_checkout_price_rule_template_fields_bogo_discount($in_fields) {
    $in_fields[] = array(
        'id' => 'bogo_discount',
        'type' => 'columns-field',
        'columns' => 6,
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => array('buy_x_get_x', 'buy_x_get_y'),
            'oparator' => 'eq',
            'clear' => true,
        ),
        'fields' => array(
            array(
                'id' => 'discount_type',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Discount Type', 'zc-woo-pricely'),
                'tooltip' => __('Controls discount amount type', 'zc-woo-pricely'),
                'options' => array(
                    'free' => __('Free', 'zc-woo-pricely'),
                    'fixed_price' => __('Fixed price', 'zc-woo-pricely'),
                    'fixed_price_unit' => __('Fixed price per unit', 'zc-woo-pricely'),
                    'fixed_discount' => __('Fixed discount amount', 'zc-woo-pricely'),
                    'fixed_discount_unit' => __('Fixed discount amount per unit', 'zc-woo-pricely'),
                    'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
                ),
                'default' => 'free',
                'width' => '100%',
                'fold_id' => 'bogo_discount_type',
            ),
            array(
                'id' => 'base_on',
                'type' => 'select2',
                'column_size' => 2,
                'column_title' => __('Base On', 'zc-woo-pricely'),
                'tooltip' => __('Controls how to calculate the discount pricing', 'zc-woo-pricely'),
                'options' => array(
                    'cart_price' => __('Cart item price', 'zc-woo-pricely'),
                    'product' => array(
                        'label' => 'Source Prices',
                        'options' => array(
                            'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                            'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                        ),
                    ),
                    'calc' => array(
                        'label' => 'Computed Prices',
                        'options' => array(
                            'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                            'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                        ),
                    ),
                ),
                'default' => 'cart_price',
                'width' => '100%',
                'fold' => array(
                    'target' => 'bogo_discount_type',
                    'attribute' => 'value',
                    'value' => array('fixed_discount', 'fixed_discount_unit', 'per_discount'),
                    'oparator' => 'eq',
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'amount',
                'type' => 'textbox',
                'input_type' => 'number',
                'column_size' => 1,
                'column_title' => __('Amount', 'zc-woo-pricely'),
                'tooltip' => __('Controls the amount to apply based on the Discount Type method', 'zc-woo-pricely'),
                'default' => '',
                'placeholder' => __('0.00', 'zc-woo-pricely'),
                'width' => '100%',
                'attributes' => array(
                    'min' => '0',
                    'step' => '0.01',
                ),
                'fold' => array(
                    'target' => 'bogo_discount_type',
                    'attribute' => 'value',
                    'value' => 'free',
                    'oparator' => 'neq',
                    'clear' => true,
                ),
            ),
            array(
                'id' => 'repeat',
                'type' => 'select2',
                'column_size' => 1,
                'column_title' => __('Repeating', 'zc-woo-pricely'),
                'tooltip' => __('Allows the discounts to apply more than once', 'zc-woo-pricely'),
                'options' => array(
                    'no' => __('No', 'zc-woo-pricely'),
                    'yes' => __('Yes', 'zc-woo-pricely'),
                ),
                'default' => 'no',
                'width' => '100%',                
            ),
        )
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_purchased_products', 120);

function zc_pri_get_checkout_price_rule_template_fields_purchased_products($in_fields) {
    $in_fields[] = array(
        'id' => 'purchased_products',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_products',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Purchased Product Filters', 'zc-woo-pricely'),
        'desc' => __('List of product filters, empty filters will not include any product', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'sortable' => array(
            'enabled' => true,
        ),
        'template_adder' => array(
            'position' => 'right', //left, right
            'show_list' => false,
            'button_text' => __('Add Filter', 'zc-woo-pricely'),
        ),
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => 'buy_x_get_y',
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
    );
    return $in_fields;
}

add_filter('zcpri/get-checkout-prices-settings-fields', 'zc_pri_get_checkout_price_rule_template_fields_discount_products', 130);

function zc_pri_get_checkout_price_rule_template_fields_discount_products($in_fields) {
    $in_fields[] = array(
        'id' => 'discount_products',
        'type' => 'simple-repeater',
        'filter_id' => 'checkout_price_discount_products',
        'full_width' => true,
        'center_head' => true,
        'title' => __('Discount Product Filters', 'zc-woo-pricely'),
        'desc' => __('List of product filters, empty filters will not include any product', 'zc-woo-pricely'),
        'white_repeater' => false,
        'repeater_size' => 'smaller',
        'buttons_sep' => false,
        'buttons_box_width' => '65px',
        'width' => '100%',
        'template_adder' => array(
            'position' => 'right', //left, right
            'show_list' => false,
            'button_text' => __('Add Filter', 'zc-woo-pricely'),
        ),
        'fold' => array(
            'target' => 'price_mode',
            'attribute' => 'value',
            'value' => 'buy_x_get_y',
            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
            'clear' => true,
        ),
    );
    return $in_fields;
}

add_filter('zcpri/sanitize-checkout-prices-buy_x_get_x-rule-settings', 'sanitize_zc_pri_checkout_prices_bogo_options');
add_filter('zcpri/sanitize-checkout-prices-buy_x_get_y-rule-settings', 'sanitize_zc_pri_checkout_prices_bogo_options');

function sanitize_zc_pri_checkout_prices_bogo_options($rule) {
    $rl = array();
    if (isset($rule['qty_base_on'])) {
        $rl['qty_base_on'] = $rule['qty_base_on'];
    }

    if (isset($rule['bogo_qty'])) {
        $rl['bogo_qty'] = $rule['bogo_qty'];
    }

    if (isset($rule['bogo_discount'])) {
        $rl['bogo_discount'] = $rule['bogo_discount'];
    }

    if (isset($rule['mode']) && $rule['mode'] == 'buy_x_get_y') {

        if (isset($rule['purchased_products'])) {
            $rl['purchased_products'] = $rule['purchased_products'];
        }

        if (isset($rule['discount_products'])) {
            $rl['discount_products'] = $rule['discount_products'];
        }
    } else {

        if (isset($rule['products'])) {
            $rl['products'] = $rule['products'];
        }
    }
    return $rl;
}
