<?php

add_filter('reon/get-simple-repeater-field-checkout_price_quantity_ranges-templates', 'zc_pri_get_checkout_price_quantity_ranges_template', 10, 2);

function zc_pri_get_checkout_price_quantity_ranges_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {
        $in_templates[] = array(
            'id' => 'range',
        );
    }

    return $in_templates;
}

add_filter('roen/get-simple-repeater-template-checkout_price_quantity_ranges-range-fields', 'zc_pri_get_checkout_price_quantity_ranges_template_fields', 10, 2);

function zc_pri_get_checkout_price_quantity_ranges_template_fields($in_fields, $args) {

    $in_fields[] = array(
        'id' => 'min_qty',
        'type' => 'textbox',
        'input_type' => 'number',
        'default' => '',
        'placeholder' => __('Minimum', 'zc-woo-pricely'),
        'width' => '97%',
        'box_width' => '19%',
        'attributes' => array(
            'min' => '0',
            'step' => '1',
        ),
    );

    $in_fields[] = array(
        'id' => 'max_qty',
        'type' => 'textbox',
        'input_type' => 'number',
        'default' => '',
        'placeholder' => __('No maximum', 'zc-woo-pricely'),
        'width' => '97%',
        'box_width' => '19%',
        'attributes' => array(
            'min' => '0',
            'step' => '1',
        ),
    );

    $in_fields[] = array(
        'id' => 'discount_type',
        'type' => 'select2',
        'options' => array(
            'fixed_price_unit' => __('Fixed price per unit', 'zc-woo-pricely'),
            'fixed_discount_unit' => __('Fixed discount amount per unit', 'zc-woo-pricely'),
            'per_discount' => __('Percentage discount', 'zc-woo-pricely'),
        ),
        'default' => 'fixed_price_unit',
        'width' => '98%',
        'box_width' => '35%',
    );


    $in_fields[] = array(
        'id' => 'amount',
        'type' => 'textbox',
        'input_type' => 'number',
        'default' => '',
        'placeholder' => __('0.00', 'zc-woo-pricely'),
        'width' => '100%',
        'box_width' => '26%',
        'attributes' => array(
            'min' => '0',
            'step' => '0.01',
        ),
    );





    return $in_fields;
}
