<?php

add_filter('reon/get-repeater-field-checkout_fees_rules-templates', 'zc_pri_get_checkout_fee_rules_template', 10, 2);

function zc_pri_get_checkout_fee_rules_template($in_templates, $args) {

    if ($args['screen'] == 'option-page' && $args['option_name'] == 'zc_pri') {
        $in_templates[] = array(
            'id' => 'fee_rule',
            'head' => array(
                'title' => '',
                'defaut_title' => __('Checkout Fee', 'zc-woo-pricely'),
                'title_field' => 'title',
                'subtitle_field' => 'admin_note',
            )
        );
    }

    return $in_templates;
}

add_filter('roen/get-repeater-template-checkout_fees_rules-fee_rule-fields', 'zc_pri_get_checkout_fee_rule_template_fields', 10, 2);

function zc_pri_get_checkout_fee_rule_template_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'last' => true,
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 4,
                'merge_fields' => false,
                'fields' => array(
                    array(
                        'id' => 'title',
                        'type' => 'textbox',
                        'tooltip' => __('Controls fee title on cart and checkout pages', 'zc-woo-pricely'),
                        'column_size' => 2,
                        'column_title' => __('Title', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'admin_note',
                        'type' => 'textbox',
                        'tooltip' => __('Adds a private note for reference purposes', 'zc-woo-pricely'),
                        'column_size' => 1,
                        'column_title' => __('Admin Note', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'send_to_group',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Send Fee To Groups', 'zc-woo-pricely'),
                        'tooltip' => __('Allows you to add the calculated fee to a group', 'zc-woo-pricely'),
                        'default' => 'yes',
                        'options' => array(
                            'no' => __('No', 'zc-woo-pricely'),
                            'yes' => __('Yes', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                        'fold_id' => 'send_to_group'
                    ),
                ),
            ),
            array(
                'id' => 'group',
                'type' => 'columns-field',
                'columns' => 2,
                'fold' => array(
                    'target' => 'send_to_group',
                    'attribute' => 'value',
                    'value' => 'yes',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'group_id',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Fee Group', 'zc-woo-pricely'),
                        'tooltip' => __('Allows to specify which fee group to send the calculated fee to', 'zc-woo-pricely'),
                        'ajax_data' => 'dpd:fee_groups',
                        'default' => 'group_0',
                        'placeholder' => __('Select group', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'inc_method',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Include Method', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how the calculated fee should be added to the group', 'zc-woo-pricely'),
                        'default' => 'increment',
                        'options' => array(
                            'increment' => __('Add amount to group', 'zc-woo-pricely'),
                            'decrement' => __('Subtract amount from group', 'zc-woo-pricely'),
                            'override' => __('Set group amount', 'zc-woo-pricely'),
                        ),
                        'width' => '100%',
                    ),
                ),
            ),
            array(
                'id' => 'single',
                'type' => 'columns-field',
                'columns' => 5,
                'fold' => array(
                    'target' => 'send_to_group',
                    'attribute' => 'value',
                    'value' => 'no',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'desc',
                        'type' => 'textbox',
                        'column_size' => 2,
                        'column_title' => __('Description', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fee description on cart and checkout pages', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                    array(
                        'id' => 'min',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Minimum', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fee minimum value', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0 minimum', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '0.01',
                        ),
                    ),
                    array(
                        'id' => 'max',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Maximum', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fee maximum value', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('No maximum', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '0.01',
                        ),
                    ),
                    array(
                        'id' => 'taxable',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Taxable', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fee tax class', 'zc-woo-pricely'),
                        'default' => '--1',
                        'options' => array(
                            '--1' => __('Not Taxable', 'zc-woo-pricely'),
                            '' => __('Standard', 'zc-woo-pricely'),
                        ),
                        'data' => 'wc:tax_classes',
                        'width' => '100%',
                    ),
                ),
            ),
            array(
                'id' => 'any_id',
                'type' => 'columns-field',
                'columns' => 1,
                'merge_fields' => false,
                'fold' => array(
                    'target' => 'send_to_group',
                    'attribute' => 'value',
                    'value' => 'no',
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                    'clear' => true,
                ),
                'fields' => array(
                    array(
                        'id' => 'notification',
                        'type' => 'textbox',
                        'column_size' => 1,
                        'column_title' => __('Cart/Checkout Notification', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the notification message on cart and checkout pages', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('Type here...', 'zc-woo-pricely'),
                        'width' => '100%',
                    ),
                )
            ),
            array(
                'id' => 'fee',
                'type' => 'columns-field',
                'columns' => 3,
                'fields' => array(
                    array(
                        'id' => 'fee_type',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Fee Type', 'zc-woo-pricely'),
                        'tooltip' => __('Controls fee amount type', 'zc-woo-pricely'),
                        'options' => array(
                            'cart' => array(
                                'label' => 'Cart Fee',
                                'options' => array(
                                    'fixed_fee' => __('Fixed fee', 'zc-woo-pricely'),
                                    'per_fee' => __('Percentage fee', 'zc-woo-pricely'),
                                ),
                            ),
                            'products' => array(
                                'label' => 'Products Fee',
                                'options' => array(
                                    'fixed_item_fee' => __('Fix fee per line item', 'zc-woo-pricely'),
                                    'fixed_unit_fee' => __('Fix fee per item unit', 'zc-woo-pricely'),
                                    'per_item_fee' => __('Percentage fee per item', 'zc-woo-pricely'),
                                ),
                            ),
                        ),
                        'default' => 'fixed_fee',
                        'width' => '100%',
                        'fold_id' => 'fee_type',
                    ),
                    array(
                        'id' => 'cart_base_on',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Base On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how to calculate the fee amount', 'zc-woo-pricely'),
                        'options' => array(
                            'subtotal' => __('Subtotal including tax', 'zc-woo-pricely'),
                            'subtotal_ex_tax' => __('Subtotal excluding tax', 'zc-woo-pricely'),
                        ),
                        'default' => 'subtotal',
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'fee_type',
                            'attribute' => 'value',
                            'value' => 'per_fee',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'item_base_on',
                        'type' => 'select2',
                        'column_size' => 1,
                        'column_title' => __('Base On', 'zc-woo-pricely'),
                        'tooltip' => __('Controls how to calculate the fee amount', 'zc-woo-pricely'),
                        'options' => array(
                            'cart_price' => __('Cart item price', 'zc-woo-pricely'),
                            'product' => array(
                                'label' => 'Source Prices',
                                'options' => array(
                                    'reg_price' => __('Source regular price', 'zc-woo-pricely'),
                                    'sale_price' => __('Source sale price', 'zc-woo-pricely'),
                                ),
                            ),
                            'calc' => array(
                                'label' => 'Computed Prices',
                                'options' => array(
                                    'calc_reg_price' => __('Computed regular price', 'zc-woo-pricely'),
                                    'calc_sale_price' => __('Computed sale price', 'zc-woo-pricely'),
                                ),
                            ),
                        ),
                        'default' => 'cart_price',
                        'width' => '100%',
                        'fold' => array(
                            'target' => 'fee_type',
                            'attribute' => 'value',
                            'value' => 'per_item_fee',
                            'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                            'clear' => true,
                        ),
                    ),
                    array(
                        'id' => 'amount',
                        'type' => 'textbox',
                        'input_type' => 'number',
                        'column_size' => 1,
                        'column_title' => __('Amount', 'zc-woo-pricely'),
                        'tooltip' => __('Controls the amount to apply based on the Fee Type method', 'zc-woo-pricely'),
                        'default' => '',
                        'placeholder' => __('0.00', 'zc-woo-pricely'),
                        'width' => '100%',
                        'attributes' => array(
                            'min' => '0',
                            'step' => '0.01',
                        ),
                    ),
                ),
            ),
            array(
                'id' => 'products',
                'type' => 'simple-repeater',
                'filter_id' => 'fee_products',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Product Filters', 'zc-woo-pricely'),
                'desc' => __('List of product filters, empty filters will include all products', 'zc-woo-pricely'),
                'white_repeater' => false,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'fold' => array(
                    'target' => 'fee_type',
                    'attribute' => 'value',
                    'value' => array('fixed_item_fee', 'fixed_unit_fee', 'per_item_fee'),
                    'oparator' => 'eq', //eq, neq, gt_eq, lt_eq, gt, lt 
                ),
                'sortable' => array(
                    'enabled' => true,
                ),
                'template_adder' => array(
                    'position' => 'right', //left, right
                    'show_list' => false,
                    'button_text' => __('Add Filter', 'zc-woo-pricely'),
                ),
            ),
        )
    );

    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'panel',
        'full_width' => true,
        'center_head' => true,
        'white_panel' => true,
        'panel_size' => 'smaller',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'conditions',
                'filter_id' => 'fee_conditions',
                'type' => 'simple-repeater',
                'full_width' => true,
                'center_head' => true,
                'title' => __('Conditions', 'zc-woo-pricely'),
                'desc' => __('List of conditions in which this rule should apply, empty conditions will apply in all cases', 'zc-woo-pricely'),
                'white_repeater' => false,
                'repeater_size' => 'smaller',
                'buttons_sep' => false,
                'buttons_box_width' => '65px',
                'width' => '100%',
                'sortable' => array(
                    'enabled' => true,
                ),
               
                'template_adder' => array(
                    'position' => 'right', //left, right
                    'show_list' => false,
                    'button_text' => __('Add Condition', 'zc-woo-pricely'),
                ),
            ),
        ),
    );

    return $in_fields;
}

add_filter('roen/get-repeater-template-checkout_fees_rules-fee_rule-head-fields', 'zc_pri_get_checkout_fee_rule_template_head_fields', 10, 2);

function zc_pri_get_checkout_fee_rule_template_head_fields($in_fields, $args) {
    $in_fields[] = array(
        'id' => 'any_id',
        'type' => 'group-field',
        'position' => 'right',
        'width' => '100%',
        'merge_fields' => false,
        'fields' => array(
            array(
                'id' => 'apply_mode',
                'type' => 'select2',
                'default' => 'with_others',
                'options' => array(
                    'with_others' => __('Apply this and other rules', 'zc-woo-pricely'),
                    'only_this' => __('Apply only this rule', 'zc-woo-pricely'),
                    'if_others' => __('Apply if other rules are valid', 'zc-woo-pricely'),
                    'if_no_others' => __('Apply if no other valid rules', 'zc-woo-pricely'),
                ),
                'width' => '210px',
            ),
            array(
                'id' => 'enable',
                'type' => 'select2',
                'default' => 'yes',
                'options' => array(
                    'yes' => __('Enable', 'zc-woo-pricely'),
                    'no' => __('Disable', 'zc-woo-pricely'),
                ),
                'width' => '95px',
            ),
        ),
    );

    return $in_fields;
}
