<?php /**
 * Plugin Name: Social Auto Poster - Instagram
 * Plugin URI: http://www.wpweb.co.in/
 * Description: Social Auto Poster - Instagram lets you add Instagram social network.
 * Version: 1.0.1
 * Author: WPWeb
 * Author URI: http://www.wpweb.co.in/
 * Text Domain: wpsapins
 * Domain Path: languages
 * 
 * @package Social Auto Poster - Instagram
 * @category Core
 * @author WPWeb
 */

// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Basic Plugin Definitions 
 * 
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
if (!defined('WPW_AUTO_POSTER_INS_VERSION')) {
    define('WPW_AUTO_POSTER_INS_VERSION', '1.0.1'); //version of plugin
}
if (!defined('WPW_AUTO_POSTER_INS_DIR')) {
    define('WPW_AUTO_POSTER_INS_DIR', dirname(__FILE__)); // plugin dir
}
if (!defined('WPW_AUTO_POSTER_INS_BASENAME')) {
    define('WPW_AUTO_POSTER_INS_BASENAME', basename(WPW_AUTO_POSTER_INS_DIR)); // base name
}
if (!defined('WPW_AUTO_POSTER_INS_SOCIAL_DIR')) {
    define('WPW_AUTO_POSTER_INS_SOCIAL_DIR', WPW_AUTO_POSTER_INS_DIR . '/includes/social/libraries'); // path to meta boxes
}
if (!defined('WPW_AUTO_POSTER_INS_URL')) {
    define('WPW_AUTO_POSTER_INS_URL', plugin_dir_url(__FILE__)); // plugin url
}
if (!defined('WPW_AUTO_POSTER_INS_IMG_URL')) {
    define('WPW_AUTO_POSTER_INS_IMG_URL', WPW_AUTO_POSTER_INS_URL . 'includes/images'); // plugin image url
}
if (!defined('WPW_AUTO_POSTER_INS_ADMIN')) {
    define('WPW_AUTO_POSTER_INS_ADMIN', WPW_AUTO_POSTER_INS_DIR . '/includes/admin'); // plugin admin dir
}
if ( ! defined( 'WPW_AUTO_POSTER_INS_PLUGIN_KEY' ) ) {
    define( 'WPW_AUTO_POSTER_INS_PLUGIN_KEY', 'sapinsta' );
}
if( !defined( 'WPWEB_UPD_DOMAIN' ) ) {
	define( 'WPWEB_UPD_DOMAIN', 'http://updater.wpweb.co.in' ); // updater domain
}

// Required Wpweb updater functions file
if ( ! function_exists( 'wpweb_updater_install' ) ) {
    require_once( 'includes/wpweb-upd-functions.php' );
}

if( class_exists( 'Wpweb_Upd_Admin' ) ) {
            
    include_once( WPWEB_UPD_DIR . '/updates/class-plugin-update-checker.php' );
    
    $WpwebWoovouPdfFontsUpdateChecker = new WpwebPluginUpdateChecker(
        WPWEB_UPD_DOMAIN . '/Updates/SAPINSTA/info.json',
        __FILE__,
        WPW_AUTO_POSTER_INS_PLUGIN_KEY
    );  
}




/**
 * Load Text Domain
 * 
 * This gets the plugin ready for translation.
 * 
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_plugins_loaded() {

    // Set filter for plugin's languages directory
    $wpw_auto_poster_ins_lang_dir = dirname(plugin_basename(__FILE__)) . '/languages/';
    $wpw_auto_poster_ins_lang_dir = apply_filters('wpw_auto_poster_languages_directory', $wpw_auto_poster_ins_lang_dir);

    // Traditional WordPress plugin locale filter
    $locale = apply_filters('plugin_locale', get_locale(), 'wpsapins');
    $mofile = sprintf('%1$s-%2$s.mo', 'wpsapins', $locale);

    // Setup paths to current locale file
    $mofile_local = $wpw_auto_poster_ins_lang_dir . $mofile;
    $mofile_global = WP_LANG_DIR . '/' . WPW_AUTO_POSTER_INS_BASENAME . '/' . $mofile;

    if (file_exists($mofile_global)) { // Look in global /wp-content/languages/social-auto-poster folder
        load_textdomain('wpsapins', $mofile_global);
    } elseif (file_exists($mofile_local)) { // Look in local /wp-content/plugins/social-auto-poster/languages/ folder
        load_textdomain('wpsapins', $mofile_local);
    } else { // Load the default language files
        load_plugin_textdomain('wpsapins', false, $wpw_auto_poster_ins_lang_dir);
    }
}

add_action('plugins_loaded', 'wpw_auto_poster_ins_plugins_loaded');




/**
 * Function to check plugin dependancies with Social Auto Poster
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_plugin_has_sap_plugin() {

    if ( is_admin() && current_user_can( 'activate_plugins' ) && !is_plugin_active( 'social-auto-poster/social-auto-poster.php' ) ) {

        add_action( 'admin_notices', 'wpw_auto_poster_ins_plugin_notice' );

        deactivate_plugins( plugin_basename( __FILE__ ) ); 

        if ( isset( $_GET['activate'] ) ) {
            unset( $_GET['activate'] );
        }
    }
    
}

add_action( 'admin_init', 'wpw_auto_poster_ins_plugin_has_sap_plugin' );

/**
 *
 * Handle to show admin notice on plugin activate.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_plugin_notice(){
    ?><div class="error"><p><?php print __( 'Sorry, but Social Auto Poster - Instagram Plugin requires the Social Auto Poster plugin to be installed and active.', 'wpsapins' )?></p></div><?php
}


/**
 * Activation Hook
 *
 * Register plugin activation hook.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
register_activation_hook(__FILE__, 'wpw_auto_poster_ins_install');


/**
 * Plugin Setup (On Activation)
 *
 * Does the initial setup, creates tables in the database and
 * stest default values for the plugin options.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_install() {

    global $wpdb;

    //get plugin options from database
    $wpw_auto_poster_options = get_option('wpw_auto_poster_options');
    

    /*** If reposter instagram options exists then merge with sap reposter options ***/
    $wpw_auto_poster_reposter_options = get_option('wpw_auto_poster_reposter_options');
    
    //get option for when plugin is activating first time
    $wpw_auto_poster_ins_set_option = get_option('wpw_auto_poster_ins_set_option');

    //check auto poster ins options is empty or not
    if ( empty($wpw_auto_poster_ins_set_option) ) 
    {
        //set default settings of social auto poster and reposter
        wpw_auto_posting_ins_default_settings();
        
        wpw_auto_posting_reposter_ins_default_settings();

        $udpopt = false;

        /*** Instagram Support Options Start ***/

        //check whether instagram is enabled
        if (!isset($wpw_auto_poster_options['enable_instagram'])) {
            $enable_instagram = array('enable_instagram' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $enable_instagram);
            $udpopt = true;
        }

        // check whether instagram is enabled for post types
        if (!isset($wpw_auto_poster_options['enable_instagram_for'])) {
            $enable_instagram_for = array('enable_instagram_for' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $enable_instagram_for);
            $udpopt = true;
        }

        //check url shortener instagram
        if (!isset($wpw_auto_poster_options['ins_url_shortener'])) {
            $ins_url_shortener = array('ins_url_shortener' => 'wordpress');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_url_shortener);
            $udpopt = true;
        }

        //check Instagram shortest api token is set or not
        if (!isset($wpw_auto_poster_options['ins_shortest_api_token'])) {
            $ins_shortest_api_token = array('ins_shortest_api_token' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_shortest_api_token);
            $udpopt = true;
        }
        
        //check Instagram bitly access token is set or not
        if (!isset($wpw_auto_poster_options['ins_bitly_access_token'])) {
            $ins_bitly_access_token = array('ins_bitly_access_token' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_bitly_access_token);
            $udpopt = true;
        }
        
        //check Instagram google short api key is set or not
        if (!isset($wpw_auto_poster_options['ins_google_short_api_key'])) {
            $ins_google_short_api_key = array('ins_google_short_api_key' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_google_short_api_key);
            $udpopt = true;
        }

        // check whether instagram account is configured
        if (!isset($wpw_auto_poster_options['instagram_keys'])) {
            $instagram_keys = array('instagram_keys' => array());
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $instagram_keys);
            $udpopt = true;
        }

        // check instagram pretty url is set or not
        if (!isset($wpw_auto_poster_options['ins_wp_pretty_url'])) {
            $ins_wp_pretty_url = array('ins_wp_pretty_url' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_wp_pretty_url);
            $udpopt = true;
        }

        // check whether to show instagram metabox in post page
        if (!isset($wpw_auto_poster_options['prevent_post_ins_metabox'])) {
            $prevent_post_ins_metabox = array('prevent_post_ins_metabox' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $prevent_post_ins_metabox);
            $udpopt = true;
        }

        // check whether instagram custom image os set or not
        if (!isset($wpw_auto_poster_options['ins_custom_img'])) {
            $ins_custom_img = array('ins_custom_img' => '' );
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_custom_img);
            $udpopt = true;
        }

        // check whether instagram default template is set or not
        if (!isset($wpw_auto_poster_options['ins_template'])) {
            $ins_template = array('ins_template' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_template);
            $udpopt = true;
        }

        // New options for category and tags taxomy selection for each social networks
        
        if (!isset($wpw_auto_poster_options['ins_post_type_tags'])) {
            $ins_post_type_tags = array('ins_post_type_tags' => array());
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_post_type_tags);
            $udpopt = true;
        }

        if (!isset($wpw_auto_poster_options['ins_post_type_cats'])) {
            $ins_post_type_cats = array('ins_post_type_cats' => array());
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_post_type_cats);
            $udpopt = true;
        }

        // code end for category and tags selection

        /*** New options for exclude category selection for each social networks start ***/
        
        if (!isset($wpw_auto_poster_options['ins_exclude_cats'])) {
            $ins_exclude_cats = array('ins_exclude_cats' => array());
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_exclude_cats);
            $udpopt = true;
        }

        /*** New options for exclude category selection for each social networks end ***/

        //check whether buffer ba_global_message_template exist or not
        if (!isset($wpw_auto_poster_options['ins_proxy'])) {
            $ins_proxy = array('ins_proxy' => '');
            $wpw_auto_poster_options = array_merge($wpw_auto_poster_options, $ins_proxy);
            $udpopt = true;
        }

        //check url shortener is google then resave it to default 
        if ( !empty( $wpw_auto_poster_options['ins_url_shortener'] ) && $wpw_auto_poster_options['ins_url_shortener'] == 'google_shortner' ) {

            $wpw_auto_poster_options['ins_url_shortener'] = 'wordpress';
            if( isset( $wpw_auto_poster_options['insgoogle_short_api_key']) ){
                unset( $wpw_auto_poster_options['insgoogle_short_api_key'] );
            }
            
            $udpopt = true;
        }

        if ($udpopt == true) { // if any of the settings need to be updated                 
            update_option('wpw_auto_poster_options', $wpw_auto_poster_options);
        }

        //update plugin version to option 
        update_option('wpw_auto_poster_ins_set_option', '1.0.0');
    }

    /*** If instagram options exists then merge with sap options ***/
    $wpw_auto_poster_ins_options = get_option('wpw_auto_poster_ins_options');

    if( !empty( $wpw_auto_poster_ins_options ) && is_array( $wpw_auto_poster_ins_options ) ) {
        
        $wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $wpw_auto_poster_ins_options );

        update_option('wpw_auto_poster_options', $wpw_auto_poster_options);
    }

    delete_option('wpw_auto_poster_ins_options');

    $wpw_auto_poster_reposter_ins_options = get_option('wpw_auto_poster_reposter_ins_options');
    
    if( !empty( $wpw_auto_poster_reposter_ins_options ) && is_array($wpw_auto_poster_reposter_ins_options ) ) {
        
        $wpw_auto_poster_reposter_options = array_merge( $wpw_auto_poster_reposter_options, $wpw_auto_poster_reposter_ins_options );
        update_option('wpw_auto_poster_reposter_options', $wpw_auto_poster_reposter_options);
    }
    
    delete_option('wpw_auto_poster_reposter_ins_options');
    
}

/**
 * Deactivation Hook
 *
 * Register plugin deactivation hook.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
register_deactivation_hook(__FILE__, 'wpw_auto_poster_ins_uninstall');

/**
 * Plugin Setup (On Deactivation)
 *
 * Deletes all the plugin options if the user has
 * set the option to do that.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_uninstall() {

    global $wpdb;

    /*---- store sap instagram settings temporary to keep as they are after deactivated ---*/
    $wpw_auto_poster_options = get_option('wpw_auto_poster_options');

    $wpw_auto_poster_ins_options = array();

    foreach ($wpw_auto_poster_options as $key => $value) {

        if ( strpos( $key, 'ins' ) !== false ) {
            
            $wpw_auto_poster_ins_options[$key] = $value;
        }
    }

   	update_option('wpw_auto_poster_ins_options', $wpw_auto_poster_ins_options);
    /*---- -------------------------------------------------------- ---*/

   	/*---- store sap reposter instagram settings temporary to keep as they are after deactivated ---*/
    $wpw_auto_poster_reposter_options = get_option('wpw_auto_poster_reposter_options');

    $wpw_auto_poster_reposter_ins_options = array();

    foreach ($wpw_auto_poster_reposter_options as $key => $value) {

        if ( strpos( $key, 'ins' ) !== false ) {
            
            $wpw_auto_poster_reposter_ins_options[$key] = $value;
        }
    }

   	update_option('wpw_auto_poster_reposter_ins_options', $wpw_auto_poster_reposter_ins_options);
    /*---- -------------------------------------------------------- ---*/

    if (isset($wpw_auto_poster_options['delete_options']) && !empty($wpw_auto_poster_options['delete_options']) && $wpw_auto_poster_options['delete_options'] == '1') {

        if( defined('WPW_AUTO_POSTER_LOGS_POST_TYPE') ) {

            // delete custom post type data
            $post_types = array(WPW_AUTO_POSTER_LOGS_POST_TYPE);
            $prefix = WPW_AUTO_POSTER_META_PREFIX;

            foreach ($post_types as $post_type) {
                $args = array('post_type' => $post_type, 'post_status' => 'any', 'numberposts' => '-1');
                $args['meta_query'] = array(
                    array(
                            'key' => $prefix . 'social_type',
                            'value' => 'ins',
                        )
                );
                $all_posts = get_posts($args);
                foreach ($all_posts as $post) {
                    wp_delete_post($post->ID, true);
                }
            }
        }
    }
}


/**
 * Default Settings
 *
 * Defining the default values for the plugin options.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_posting_ins_default_settings() {

    global $wpw_auto_poster_options;

    //default values
    $wpw_auto_poster_ins_default_options = array(
      
        'enable_instagram' => '',
        'enable_instagram_for' => '',
        'ins_post_type_tags' => array(),
        'ins_post_type_cats' => array(),
        'ins_exclude_cats' => array(),
        'ins_url_shortener' => 'wordpress',
        'ins_bitly_access_token' => '',
        'ins_shortest_api_token' => '',
        'ins_google_short_api_key' => '',
        'instagram_keys' => array(),
        'ins_wp_pretty_url' => '',
        'prevent_post_ins_metabox' => '',
        'ins_custom_img' => '' ,
        'ins_template'  => '',                                    
    );
    
    $wpw_auto_poster_options = array_merge( $wpw_auto_poster_options, $wpw_auto_poster_ins_default_options );

    update_option('wpw_auto_poster_options', $wpw_auto_poster_options);
}

/**
 * Default Settings
 *
 * Defining the default values for the plugin reposter options.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_posting_reposter_ins_default_settings() {
    
    global $wpw_auto_poster_reposter_options;

    //default values
    $wpw_auto_poster_reposter_ins_default_options = array(
        
        'enable_instagram' => '',
        'enable_instagram_for' => '',
        'ins_posts_limit' => 5,
        'ins_posting_cats' => 'include',
        'ins_post_type_cats' => array(),
        'ins_last_posted_page' => 1,
        'ins_post_ids_exclude' => '',
    );

    $wpw_auto_poster_reposter_options = array_merge( $wpw_auto_poster_reposter_options, $wpw_auto_poster_reposter_ins_default_options );

    update_option('wpw_auto_poster_reposter_options', $wpw_auto_poster_reposter_options);
}


/**
 * Add plugin action links
 *
 * Adds a settings, support and docs link to the plugin list.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
function wpw_auto_poster_ins_add_settings_link($links) {
    $plugin_links = array(
        '<a href="' . add_query_arg(array('page' => 'wpw-auto-poster-settings'), admin_url('admin.php')) . '">' . __('Settings', 'wpsapins') . '</a>',
        '<a href="http://support.wpweb.co.in/">' . __('Support', 'wpsapins') . '</a>',
        '<a href="http://wpweb.co.in/documents/social-auto-poster/">' . __('Docs', 'wpsapins') . '</a>'
    );

    return array_merge($plugin_links, $links);
}


//add plugin settings, support and docs link to plugin listing page         
add_filter('plugin_action_links_' . plugin_basename(__FILE__), 'wpw_auto_poster_ins_add_settings_link');


global $wpw_auto_poster_ins_posting,$wpw_auto_poster_ins_admin;


//Instagram Posting Class since 1.0.0
require_once( WPW_AUTO_POSTER_INS_DIR . '/includes/social/class-wpw-auto-poster-ins-posting.php' );// instagram posting class
$wpw_auto_poster_ins_posting = new Wpw_Auto_Poster_INS_Posting();

//Instagram Posting Class since 1.0.0
require_once( WPW_AUTO_POSTER_INS_ADMIN . '/class-wpw-auto-poster-ins-admin.php' );// instagram posting class
$wpw_auto_poster_ins_admin = new Wpw_Auto_Posting_Ins_AdminPages();
$wpw_auto_poster_ins_admin->add_hooks();
