<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Instagram Settings
 *
 * The html markup for the Instagram settings tab.
 *
 * @package Social Auto Poster
 * @since 2.6.0
 */

global $wpw_auto_poster_options, $wpw_auto_poster_model;

// model class
$model = $wpw_auto_poster_model;

$instagram_keys = isset( $wpw_auto_poster_options['instagram_keys'] ) ? $wpw_auto_poster_options['instagram_keys'] : array();

$ins_wp_pretty_url = ( !empty( $wpw_auto_poster_options['ins_wp_pretty_url'] ) ) ? $wpw_auto_poster_options['ins_wp_pretty_url'] : '';

$ins_wp_pretty_url = !empty( $ins_wp_pretty_url ) ? ' checked="checked"' : '';
$ins_wp_pretty_url_css = ( $wpw_auto_poster_options['ins_url_shortener'] == 'wordpress' ) ? ' display:table-row': ' display:none';

// get url shortner service list array 
$ins_url_shortener = $model->wpw_auto_poster_get_shortner_list();

$ins_exclude_cats = array();

$error_msgs = array();
$readonly = "";



// Check if gd library loaded or not.
if( !extension_loaded('gd') ) {
   $error_msgs[] = sprintf( __( 'Instagram requires %sGD%s PHP library enabled. Contact your host or server administrator to configure and install the missing library.', 'wpsapins' ), '<b>', '</b>' );
   $readonly = 'readonly';
}

// Check if Exif is enabled or not
if( !function_exists('exif_imagetype') ) {   
   $error_msgs[] = sprintf( __( 'Instagram requires %sExif%s PHP library enabled. Contact your host or server administrator to configure and install the missing library.', 'wpsapins' ), '<b>', '</b>' );
   $readonly = 'readonly';
}

$ins_custom_msg_options = isset( $wpw_auto_poster_options['ins_custom_msg_options'] ) ? $wpw_auto_poster_options['ins_custom_msg_options'] : 'global_msg';

if( $ins_custom_msg_options == 'global_msg') {
	$post_msg_style = "display:none";
	$global_msg_style = "";
} else{
	$global_msg_style = "display:none";
	$post_msg_style = "";
}

?>

<!-- beginning of the instagram general settings meta box -->
<div id="wpw-auto-poster-instagram-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="instagram_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpsapins' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'تنظیمات عمومی اینستاگرام', 'wpsapins' ); ?></span>
					</h3>
									
					<div class="inside">
						<?php if(!empty($error_msgs)) { ?>
							<div class="wpw-auto-poster-error">
                                <ul>
                                    <?php foreach ( $error_msgs as $error_msg ) { ?>
                                        <li><?php echo $error_msg;?></li>
                                    <?php } ?>
                                </ul>								
							</div>
						<?php } ?>				
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_instagram]"><?php _e( 'ارسال خودکار در اینستاگرام را فعال کنید:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_options[enable_instagram]" id="wpw_auto_poster_options[enable_instagram]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['enable_instagram'] ) ) { checked( '1', $wpw_auto_poster_options['enable_instagram'] ); } ?> />
										<p><small><?php _e( 'اگر می خواهید به طور خودکار محتوای جدید خود را در اینستاگرام ارسال کنید ، این کادر را علامت بزنید.', 'wpsapins' ); ?></small></p>
									</td>
								</tr>

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[enable_instagram_for]"><?php _e( 'ارسال خودکار اینستاگرام برای:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_options['enable_instagram_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_options['enable_instagram_for'];
											} else {
												$prevent_meta = array();
											}

											if( !empty( $wpw_auto_poster_options['ins_post_type_tags'] ) ) {
												$ins_post_type_tags = $wpw_auto_poster_options['ins_post_type_tags'];
											} else {
												$ins_post_type_tags = array();
											}

											$static_post_type_arr = wpw_auto_poster_get_static_tag_taxonomy();

											if( !empty( $wpw_auto_poster_options['ins_post_type_cats'] ) ) {
												$ins_post_type_cats = $wpw_auto_poster_options['ins_post_type_cats'];
											} else {
												$ins_post_type_cats = array();
											}

											// Get saved categories for instagram to exclude from posting
											if( !empty( $wpw_auto_poster_options['ins_exclude_cats'] ) ) {
												$ins_exclude_cats = $wpw_auto_poster_options['ins_exclude_cats'];
											} 

											foreach( $all_types as $type ) {	
												
												if( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
													
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_instagram_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_options[enable_instagram_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_instagram_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'هر یک از انواع ارسال را می خواهید هنگام انتشار به طور خودکار در اینستاگرام بررسی کنید.', 'wpsapins' ); ?></small></p>  
									</td>
								</tr>
									
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_post_type_tags][]"><?php _e( 'برچسب را انتخاب کنید:', 'wpsapins' ); ?></label> 
									</th>
									<td class="wpw-auto-poster-select">
										<select name="wpw_auto_poster_options[ins_post_type_tags][]" id="wpw_auto_poster_options[ins_post_type_tags]" class="ins_post_type_tags wpw-auto-poster-cats-tags-select" multiple="multiple">
											<?php foreach( $all_types as $type ) {	
												
												if( !is_object( $type ) ) continue;	

													if(in_array( $type->name, $prevent_meta )) {

														$label = @$type->labels->name ? $type->labels->name : $type->name;
														if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
														$all_taxonomies = get_object_taxonomies( $type->name, 'objects' );
	                							
	                									echo '<optgroup label="'.$label.'">';
										                // Loop on all taxonomies
										                foreach ( $all_taxonomies as $taxonomy ) {

										                	$selected = '';

										                	if( !empty( $static_post_type_arr[$type->name] ) && $static_post_type_arr[$type->name] != $taxonomy->name){
                             										continue;
                    										}

										                	if(isset($ins_post_type_tags[$type->name]) && !empty($ins_post_type_tags[$type->name])) {
										                		$selected = ( in_array( $taxonomy->name, $ins_post_type_tags[$type->name] ) ) ? 'selected="selected"' : '';
										                	}
										                    if (is_object($taxonomy) && $taxonomy->hierarchical != 1) {

										                        echo '<option value="' . $type->name."|".$taxonomy->name . '" '.$selected.'>'.$taxonomy->label.'</option>';
										                    }
										                }
										                echo '</optgroup>';
										            }
											}?>
										</select>
										<div class="wpw-ajax-loader"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL."/icons/ajax-loader.gif";?>"/></div>
										<p><small><?php _e( 'برچسب ها را برای انواع پست که می خواهید ارسال کنید ، انتخاب کنید ', 'wpsapins' ); ?><b><?php _e('hashtags.', 'wpsapins' );?></b></small></p>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_post_type_cats][]"><?php _e( 'دسته ها را انتخاب کنید:', 'wpsapins' ); ?></label> 
									</th>
									<td class="wpw-auto-poster-select">
										<select name="wpw_auto_poster_options[ins_post_type_cats][]" id="wpw_auto_poster_options[ins_post_type_cats]" class="ins_post_type_cats wpw-auto-poster-cats-tags-select" multiple="multiple">
											<?php foreach( $all_types as $type ) {	
												
												if( !is_object( $type ) ) continue;	

													if(in_array( $type->name, $prevent_meta )) {														
														$label = @$type->labels->name ? $type->labels->name : $type->name;
														if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
														$all_taxonomies = get_object_taxonomies( $type->name, 'objects' );
	                							
	                									echo '<optgroup label="'.$label.'">';
										                // Loop on all taxonomies
										                foreach ($all_taxonomies as $taxonomy){

										                	$selected = '';
										                	if(isset($ins_post_type_cats[$type->name]) && !empty($ins_post_type_cats[$type->name])) {
										                		$selected = ( in_array( $taxonomy->name, $ins_post_type_cats[$type->name]) ) ? 'selected="selected"' : '';
										                	}
										                    if (is_object($taxonomy) && $taxonomy->hierarchical == 1) {

										                        echo '<option value="' . $type->name."|".$taxonomy->name . '" '.$selected.'>'.$taxonomy->label.'</option>';
										                    }
										                }
										                echo '</optgroup>';
										            }
											}?>
										</select>
										<div class="wpw-ajax-loader"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL."/icons/ajax-loader.gif";?>"/></div>
										<p><small><?php _e( 'دسته بندی ها را برای هر نوع پست که می خواهید ارسال کنید ، انتخاب کنید ', 'wpsapins' ); ?><b><?php _e('hashtags.', 'wpsapins' );?></b></small></p>
									</td>
								</tr>	
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_exclude_cats][]"><?php _e( 'طبقه بندی را حذف نکنید:', 'wpsapins' ); ?></label> 
									</th>
									<td class="wpw-auto-poster-select">
										<select name="wpw_auto_poster_options[ins_exclude_cats][]" id="wpw_auto_poster_options[ins_exclude_cats]" class="ins_exclude_cats wpw-auto-poster-cats-exclude-select" multiple="multiple">
											
											<?php

												$post_type_categories = wpw_auto_poster_get_all_categories_and_tags();

												if(!empty($post_type_categories)) {
													
													foreach($post_type_categories as $post_type => $post_data){

														echo '<optgroup label="'.$post_data['label'].'">';

														if(isset($post_data['categories']) && !empty($post_data['categories']) && is_array($post_data['categories'])){
															
															foreach($post_data['categories'] as $cat_slug => $cat_name){

																$selected = '';
																if( !empty( $ins_exclude_cats[$post_type] ) ) {
											                		$selected = ( in_array( $cat_slug, $ins_exclude_cats[$post_type] ) ) ? 'selected="selected"' : '';
											                	}
																echo '<option value="' . $post_type ."|".$cat_slug . '" '.$selected.'>'.$cat_name.'</option>';
															}

														}
														echo '</optgroup>';
													}
												}

											?>

										</select>
										<p><small><?php _e( 'طبقه بندی ها را برای انواع پست که می خواهید ارسال  کنید انتخاب کنید.', 'wpsapins' ); ?></small></p>
									</td>
								</tr>
															
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_url_shortener]"><?php _e( 'کوتاه کننده آدرس:', 'wpsapins' ); ?></label> 
									</th>
									<td>
										<select name="wpw_auto_poster_options[ins_url_shortener]" id="wpw_auto_poster_options[ins_url_shortener]" class="ins_url_shortener" data-content='ins'>
											<?php
																
												foreach ( $ins_url_shortener as $key => $option ) {											
													?>
													<option value="<?php echo $model->wpw_auto_poster_escape_attr( $key ); ?>" <?php selected( $wpw_auto_poster_options['ins_url_shortener'], $key ); ?>>
														<?php esc_html_e( $option ); ?>
													</option>
													<?php
												}
											?>
										</select>
										<p><small><?php _e( 'URL های طولانی به طور خودکار با استفاده از کوتاه کننده URL مشخص شده کوتاه می شوند.', 'wpsapins' ); ?></small></p>
									</td>
								</tr>

								

								<tr id="row-ins-wp-pretty-url" valign="top" style="<?php print $ins_wp_pretty_url_css;?>">
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_wp_pretty_url]"><?php _e( 'آدرس پیوند:', 'wpsapins' ); ?></label> 
									</th>
									<td>
										<input type="checkbox" name="wpw_auto_poster_options[ins_wp_pretty_url]" id="wpw_auto_poshttps://demoapus.com/landing-page/edumy/ter_options[ins_wp_pretty_url]" class="ins_wp_pretty_url" data-content='ins' value="yes" <?php print $ins_wp_pretty_url;?>>
										<p><small><?php _e( 'اگر می خواهید از پیوند پیوندهای زیبا استفاده کنید ، این کادر را علامت بزنید به عنوان مثال http://example.com/test-post/. (توصیه نشده است).', 'wpsapins' ); ?></small></p>
									</td>
								</tr>
								
								<?php	        
									
		                            $class = $shortest_class = ' style="display:none;"';

									if( $wpw_auto_poster_options['ins_url_shortener'] == 'bitly' ) {	        		
										$class = '';	        		
									} else if( $wpw_auto_poster_options['ins_url_shortener'] == 'shorte.st' ) {
										$shortest_class = '';	        		
									}
								?>
								
								<tr valign="top" class="ins_setting_input_bitly"<?php echo $class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_bitly_access_token]"><?php _e( 'Bit.ly Access Token', 'wpsapins' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[ins_bitly_access_token]" id="wpw_auto_poster_options[ins_bitly_access_token]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_bitly_access_token'] ); ?>" class="large-text">
									</td>
								</tr>
								
								<tr valign="top" class="ins_setting_input_shortest"<?php echo $shortest_class; ?>>
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_shortest_api_token]"><?php _e( 'Shorte.st API Token', 'wpsapins' ); ?> </label>
									</th>
									<td>
										<input type="text" name="wpw_auto_poster_options[ins_shortest_api_token]" id="wpw_auto_poster_options[ins_shortest_api_token]" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_shortest_api_token'] ); ?>" class="large-text">
									</td>
								</tr>
							 								
								<?php
									echo apply_filters ( 
														 'wpweb_fb_settings_submit_button', 
														 '<tr valign="top">
																<td colspan="2">
																	<input type="submit" value="' . __( 'ذخیره تغییرات', 'wpsapins' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
																</td>
															</tr>'
														);
								?>
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #instagram_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-instagram-general -->
<!-- end of the instagram general settings meta box -->

<!-- beginning of the instagram api settings meta box -->
<div id="wpw-auto-poster-instagram-api" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="instagram_api" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpsapins' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'تنظیمات API اینستاگرام', 'wpsapins' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table wpw-auto-poster-instagram-settings">											
							<tbody>				
								<tr valign="top">
									<td scope="row">
										<strong><label><?php _e( 'برنامه اینستاگرام:', 'wpsapins' ); ?></label></strong>
									</td>
									<td colspan="3">
										<p>
										<?php _e( 'قبل از شروع انتشار محتوای خود در اینستاگرام ، باید نام کاربری و رمزعبور اینستاگرام خود را تهیه کنید.', 'wpsapins' ); ?>
										</p>  
									</td>
								</tr>
								
								<tr valign="top">
									<td scope="row">
										<strong><label for="wpw_auto_poster_options[instagram_keys][0][username]"><?php _e( 'نام کاربری اینستاگرام', 'wpsapins' ); ?></label></strong>
									</td>
									<td scope="row">
										<strong><label for="wpw_auto_poster_options[instagram_keys][0][password]"><?php _e( 'کلمه عبور اینستاگرام', 'wpsapins' ); ?></label></strong>
									</td>
									
									<td></td>
								</tr>
								
							<?php

							if( !empty( $instagram_keys ) ) {
								
								foreach ( $instagram_keys as $instagram_key => $instagram_value ) {
									
									// Don't disply delete link for first row
									$instagram_delete_class = empty( $instagram_key ) ? '' : ' wpw-auto-poster-display-inline ';
							?>
								<tr valign="top" class="wpw-auto-poster-instagram-account-details" data-row-id="<?php echo $instagram_key; ?>">
									<td scope="row" width="30%">
										<input type="text" name="wpw_auto_poster_options[instagram_keys][<?php echo $instagram_key; ?>][username]" value="<?php echo $model->wpw_auto_poster_escape_attr( $instagram_value['username'] ); ?>" class="large-text wpw-auto-poster-instagram-username" <?php echo $readonly;?>/>
										<p><small><?php _e( 'نام کاربری اینستاگرام خود را وارد کنید.', 'wpsapins' ); ?></small></p>  
									</td>
									<td scope="row" width="30%">
										<input type="password" name="wpw_auto_poster_options[instagram_keys][<?php echo $instagram_key; ?>][password]" value="<?php echo $model->wpw_auto_poster_escape_attr( $instagram_value['password'] ); ?>" class="large-text wpw-auto-poster-instagram-password" <?php echo $readonly;?>/>
										<p><small><?php _e( 'رمز عبور اینستاگرام خود را وارد کنید', 'wpsapins' ); ?></small></p>  
									</td>
									
									<td>
										<a href="javascript:void(0);" class="wpw-auto-poster-delete-ins-account wpw-auto-poster-instagram-remove <?php echo $instagram_delete_class; ?>" title="<?php _e( 'Delete', 'wpsapins' ); ?>"><img src="<?php echo WPW_AUTO_POSTER_META_URL; ?>/images/delete-16.png" alt="<?php _e('Delete','wpsapins'); ?>"/></a>
									</td>
								</tr>
							<?php 
								}
							} else {
							?>
								<tr valign="top" class="wpw-auto-poster-instagram-account-details" data-row-id="<?php echo (empty($instagram_key) ? '': $instagram_key); ?>">
									<td scope="row" width="30%">
										<input type="text" name="wpw_auto_poster_options[instagram_keys][0][username]" value="" class="large-text wpw-auto-poster-instagram-username" />
										<p><small><?php _e( 'نام کاربری اینستاگرام خود را وارد کنید.', 'wpsapins' ); ?></small></p>  
									</td>
									<td scope="row" width="30%">
										<input type="password" name="wpw_auto_poster_options[instagram_keys][0][password]" value="" class="large-text wpw-auto-poster-instagram-password" />
										<p><small><?php _e( 'رمز عبور اینستاگرام خود را وارد کنید', 'wpsapins' ); ?></small></p>  
									</td>
									<td>
										<a href="javascript:void(0);" class="wpw-auto-poster-delete-ins-account wpw-auto-poster-instagram-remove" title="<?php _e( 'Delete', 'wpsapins' ); ?>"><img src="<?php echo WPW_AUTO_POSTER_META_URL; ?>/images/delete-16.png" alt="<?php _e('Delete','wpsapins'); ?>"/></a>
									</td>
								</tr>
							<?php } ?>
							
								<tr>
									<td colspan="4">
										<a class='wpw-auto-poster-add-more-ins-account button' href='javascript:void(0);'><?php _e( 'افزودن بیشتر', 'wpsapins' ); ?></a>
									</td>
								</tr> 
								
								<?php
									echo apply_filters ( 
														 'wpweb_fb_settings_submit_button', 
														 '<tr valign="top">
																<td colspan="4">
																	<input type="submit" value="' . __( 'ذخیره تغییرات', 'wpsapins' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
																</td>
															</tr>'
														);
								?>
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #instagram_api -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-instagram-api -->
<!-- end of the instagram api settings meta box -->

<!-- beginning of the autopost to instagram meta box -->
<div id="wpw-auto-poster-autopost-instagram" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="autopost_instagram" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpsapins' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'ارسال خودکار به اینستاگرام', 'wpsapins' ); ?></span>
					</h3>
									
					<div class="inside">
										
						<table class="form-table">											
							<tbody>
							
								<tr valign="top"> 
									<th scope="row">
										<label for="wpw_auto_poster_options[prevent_post_ins_metabox]"><?php _e( 'پست های فردی را در اینستاگرام اجازه ندهید:', 'wpsapins' ); ?></label>
									</th>									
									<td>
										<input name="wpw_auto_poster_options[prevent_post_ins_metabox]" id="wpw_auto_poster_options[prevent_post_ins_metabox]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_options['prevent_post_ins_metabox'] ) ) { checked( '1', $wpw_auto_poster_options['prevent_post_ins_metabox'] ); } ?> />
										<p><small><?php _e( 'اگر یک وبلاگ چند نویسنده اجرا می کنید ، می توانید با چک کردن این کادر ، مانع از انتشار نویسندگان خود در حساب های شخصی اینستاگرام شوید. در صورت بررسی ، تمام پستهای ایجاد شده توسط هر نویسنده به حساب اینستاگرام منتخب شما ارسال می شوند.', 'wpsapins' ); ?></small></p>
									</td>	
								</tr>
                                
                                <tr valign="top">
									<th scope="row">
                                        <label for="wpw_auto_poster_options[ins_proxy]"><?php _e( 'پروکسی', 'wpsapins' ); ?></label>
									</th>
									<td scope="row">
                                        <textarea rows="5" cols="70" id="wpw_auto_poster_options[ins_proxy]" name="wpw_auto_poster_options[ins_proxy]" placeholder="یک IP را در هر خط وارد کنید (به عنوان مثال: http://00.00.00.00:(port) یا با ssl)"><?php echo !empty($wpw_auto_poster_options['ins_proxy'])? $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_proxy'] ): ''; ?></textarea>
                                        <p><small><?php _e( 'یک IP را در هر خط وارد کنید (به عنوان مثال: http://00.00.00.00:(port) یا با ssl)', 'wpsapins' ); ?></small></p>
									</td>																		
								</tr>
								
								<?php
								
									$types = get_post_types( array( 'public'=>true ), 'objects' );
									$types = is_array( $types ) ? $types : array();
								?>
								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'انواع وردپرس را به مکان های اینستاگرام نمایش دهید:', 'wpsapins' ); ?></label>
									</th>
									<td>
										
											<?php
												
												// Getting all instagram accounts
												$ins_accounts = $instagram_keys;
												
												foreach( $types as $type ) {
													
													if( !is_object( $type ) ) continue;
													
	
														$label = @$type->labels->name ? $type->labels->name : $type->name;
														
														if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
													?>
													<div class="wpw-auto-poster-fb-types-wrap">
														<div class="wpw-auto-poster-fb-types-label">
															<?php	_e( 'Autopost', 'wpsapins' ); 
																	echo ' '.$label; 
																	_e( ' to Instagram', 'wpsapins' ); 
															?>
														</div><!--.wpw-auto-poster-fb-types-label-->
														
														<div class="wpw-auto-poster-fb-user-label">
															<?php _e( 'of this user', 'wpsapins' ); ?>(<?php _e( 's', 'wpsapins' );?>)
														</div><!--.wpw-auto-poster-fb-user-label-->
														<div class="wpw-auto-poster-fb-users-acc">
															<?php
																if( isset( $wpw_auto_poster_options['ins_type_'.$type->name.'_user'] ) ) {
																	$wpw_auto_poster_ins_type_user = $wpw_auto_poster_options['ins_type_'.$type->name.'_user'];	 
																} else {
																	$wpw_auto_poster_ins_type_user = '';
																}
																
																$wpw_auto_poster_ins_type_user = ( array ) $wpw_auto_poster_ins_type_user;

															?>
															<select name="wpw_auto_poster_options[ins_type_<?php echo $type->name; ?>_user][]" multiple="multiple" class="wpw-auto-poster-users-acc-select">
																<?php
																if( !empty($ins_accounts) && is_array($ins_accounts) ) {
																	
																	foreach( $ins_accounts as $aid => $aval ) {

																		if( is_array( $aval ) ) { 
																				$value = $aval['username']."|".$aval['password'];
																				?>
																				<option value="<?php echo $value; ?>" <?php selected( in_array( $value, $wpw_auto_poster_ins_type_user ), true, true ); ?>><?php echo $aval['username']; ?></option>
																			
																			</optgroup>
																			
																<?php	} else { ?>
																				<option value="<?php echo $aid; ?>" <?php selected( in_array( $aid, $wpw_auto_poster_ins_type_user ), true, true ); ?> ><?php echo $aval; ?></option>
																<?php 	}
																	
																	} // End of foreach
																} // End of main if
																?>
															</select>
														</div><!--.wpw-auto-poster-fb-users-acc-->
													</div><!--.wpw-auto-poster-fb-types-wrap-->
											<?php } ?>
										
									</td>
								</tr>

								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'تنظیمات فرمت ارسال', 'wpsapins' ); ?></label>
									</th>
									<td>
										<input id="ins_custom_global_msg" type="radio" name="wpw_auto_poster_options[ins_custom_msg_options]" value="global_msg" <?php checked($ins_custom_msg_options, 'global_msg', true);?> class="custom_msg_options">
										<label for="ins_custom_global_msg" class="wpw-auto-poster-label"><?php _e( 'جهانی', 'wpsapins' ); ?></label>
	                                    
	                                    <input id="ins_custom_post_msg" type="radio" name="wpw_auto_poster_options[ins_custom_msg_options]" value="post_msg" <?php checked($ins_custom_msg_options, 'post_msg', true);?> class="custom_msg_options">
	                                    <label for="ins_custom_post_msg" class="wpw-auto-poster-label"><?php _e( 'فردی نوع ارسال پیام', 'wpsapins' ); ?></label>
									</td>	
								</tr>

								<tr valign="top" style="<?php echo $global_msg_style; ?>" class="global_msg_tr">
									<th scope="row">
										<label for="wpw_auto_poster_options_ins_custom_img"><?php _e( 'تصویر ارسال', 'wpsapins' ); ?></label>
										
									</th>
									<td>
										<input type="text" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_custom_img'] ); ?>" name="wpw_auto_poster_options[ins_custom_img]" id="wpw_auto_poster_options_ins_custom_img" class="large-text wpw-auto-poster-img-field">
										<input type="button" class="button-secondary wpw-auto-poster-uploader-button" name="wpw-auto-poster-uploader" value="<?php _e( 'افزودن تصویر','wpsapins' );?>" />
										<p><small><?php _e( 'در اینجا می توانید یک تصویر پیش فرض را که برای پست دیواری اینستاگرام استفاده خواهد شد بارگذاری کنید.', 'wpsapins' ); ?></small></p><br>
										<p><small><strong><?php _e('توجه:', 'wpsapins'); ?> </strong><?php 
											$ins_notes = __('برای ارسال اینستاگرام به یک تصویر حداقل نیاز دارد.', 'wpsapins');

											$ins_notes .= '<b>'.__('عرض تصویر بین 320 تا 1080 پیکسل توصیه می شود.', 'wpsapins').'</b><br><br>';

											$ins_notes .= __( 'اگر عرض تصویر کمتر از 320 پیکسل باشد ، به طور خودکار به 320 پیکسل افزایش می یابد. اگر عرض تصویر از 1080 پیکسل بیشتر باشد ، به طور خودکار به 1080 پیکسل تغییر می کند.', 'wpsapins' );
											print $ins_notes;

										?></small></p>
										
									</td>	
								</tr>
								
								<tr valign="top" style="<?php echo $global_msg_style; ?>" class="global_msg_tr">									
									<th scope="row">
										<label for="wpw_auto_poster_options[ins_template]"><?php _e( 'پیام سفارشی', 'wpsapins' ); ?></label>
									</th>
									<td>
										<textarea name="wpw_auto_poster_options[ins_template]" id="wpw_auto_poster_options[ins_template]" class="large-text"><?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_template'] ); ?></textarea>
									</td>	
								</tr>

								<tr id="custom_post_type_templates_ins" style="<?php echo $post_msg_style; ?>" class="post_msg_tr">
									<th colspan="2">
									  	<ul>
									  		<?php
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();

											foreach( $all_types as $type ) {	
											
												if( !is_object( $type ) ) continue;															
												$label = @$type->labels->name ? $type->labels->name : $type->name;

												if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
												
											?>
										    <li><a href="#tabs-<?php echo $type->name; ?>"><?php echo $label; ?></a></li>
									  		<?php } ?>

									  	</ul>
									  	<?php 
									  	foreach( $all_types as $type ) {	
										
											if( !is_object( $type ) ) continue;															
											$label = @$type->labels->name ? $type->labels->name : $type->name;

											if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
												
											$wpw_auto_poster_options['ins_template_'.$type->name] = ( isset( $wpw_auto_poster_options['ins_template_'.$type->name] ) ) ? $wpw_auto_poster_options['ins_template_'.$type->name] : '';
												
											$wpw_auto_poster_options['ins_custom_img_'.$type->name] = ( isset( $wpw_auto_poster_options['ins_custom_img_'.$type->name] ) ) ? $wpw_auto_poster_options['ins_custom_img_'.$type->name] : '';
									  	?>
									  	<table id="tabs-<?php echo $type->name; ?>">
											<tr valign="top">
												<th scope="row">
													<label for="wpw_auto_poster_options_ins_custom_img_<?php echo $type->name; ?>"><?php _e( 'Post Image:', 'wpsapins' ); ?></label>
													
												</th>
												<td>
													<input type="text" value="<?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_custom_img_'.$type->name] ); ?>" name="wpw_auto_poster_options[ins_custom_img_<?php echo $type->name; ?>]" id="wpw_auto_poster_options_ins_custom_img_<?php echo $type->name; ?>" class="large-text wpw-auto-poster-img-field">
													<input type="button" class="button-secondary wpw-auto-poster-uploader-button" name="wpw-auto-poster-uploader" value="<?php _e( 'Add Image','wpsapins' );?>" />
													<p><small><?php _e( 'در اینجا می توانید یک تصویر پیش فرض را که برای پست دیواری اینستاگرام استفاده خواهد شد بارگذاری کنید.', 'wpsapins' ); ?></small></p><br>
													<p><small><strong><?php _e('توجه:', 'wpsapins'); ?> </strong><?php 
														$ins_notes = __('برای ارسال اینستاگرام به یک تصویر حداقل نیاز دارد.', 'wpsapins');

														$ins_notes .= '<b>'.__('عرض تصویر بین 320 تا 1080 پیکسل توصیه می شود.', 'wpsapins').'</b><br><br>';

														$ins_notes .= __( 'اگر عرض تصویر کمتر از 320 پیکسل باشد ، به طور خودکار به 320 پیکسل افزایش می یابد. اگر عرض تصویر از 1080 پیکسل بیشتر باشد ، به طور خودکار به 1080 پیکسل تغییر می کند.', 'wpsapins' );
														print $ins_notes;

													?></small></p>
													
												</td>	
											</tr>
															
											<tr valign="top">

												<th scope="row">
													<label for="wpw_auto_posting_ins_custom_msg_<?php echo $type->name; ?>"><?php echo __('Custom Message', 'wpwautoposter'); ?>:</label>
												</th>

												<td>
													<textarea type="text" name="wpw_auto_poster_options[ins_template_<?php echo $type->name; ?>]" id="wpw_auto_posting_ins_custom_msg_<?php echo $type->name; ?>" class="large-text"><?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_options['ins_template_'.$type->name] ); ?></textarea>
													<p><small><?php _e('Leave it empty for global custom message.','wpsapins');?></small></p>
												</td>	
											</tr>
										</table>
									<?php } ?>
									</th>
								</tr>	
								<tr valign="top">									
									<th scope="row"></th>
									<td>
										<p><small style="line-height: 20px;"><?php _e( 'در اینجا می توانید عنوان پیش فرض را وارد کنید که برای جدول زمانی استفاده خواهد شد. برای استفاده از زیرنویس سطح پست آن را خالی بگذارید. می توانید از قالب های زیر در قالب زیرنویس استفاده کنید:', 'wpsapins' ); ?>
										<?php 
										$ins_template_str = '<br /><code>{first_name}</code> - ' . __('displays the first name,', 'wpsapins') .
							            '<br /><code>{last_name}</code> - ' . __('displays the last name,', 'wpsapins') .
							            '<br /><code>{display_name}</code> - ' . __('displays the display name,', 'wpsapins') .
							            '<br /><code>{title}</code> - ' . __('displays the default post title,', 'wpsapins') .
							            '<br /><code>{link}</code> - ' . __('displays the default post link,', 'wpsapins') .
							            '<br /><code>{full_author}</code> - ' . __('displays the full author name,', 'wpsapins') .
							            '<br /><code>{nickname_author}</code> - ' . __('displays the nickname of author,', 'wpsapins') .
							            '<br /><code>{post_type}</code> - ' . __(' displays the post type,', 'wpsapins') .
							            '<br /><code>{sitename}</code> - ' . __('displays the name of your site,', 'wpsapins') .
							            '<br /><code>{excerpt}</code> - ' . __('displays the post excerpt.', 'wpsapins').
							            '<br /><code>{hashtags}</code> - ' . __('displays the post tags as hashtags.', 'wpsapins').
							            '<br /><code>{hashcats}</code> - ' . __('displays the post categories as hashtags.', 'wpsapins').
							            '<br /><code>{content}</code> - ' . __('displays the post content.', 'wpsapins').
						           		'<br /><code>{content-digits}</code> - ' . __('محتوای ارسال را با تعداد مشخصی از رقم در برچسب قالب نمایش می دهد. <b> به عنوان مثال، اگر الگویی مانند {content-100 add اضافه کنید ، سپس 100 حرف اول را از محتوای ارسال نمایش می دهد.</b>', 'wpsapins').
						            	'<br /><code>{CF-CustomFieldName}</code> - ' . __('محتویات زمینه دلخواه را با نام مشخص شده وارد می کند. <b> به عنوان مثال، اگر قیمت شما در قسمت "PRDPRICE" سفارشی ذخیره می شود ، باید از برچسب {CF-PRDPRICE use استفاده کنید.</b>', 'wpsapins');
							            print $ins_template_str;
							            ?>
										</small></p>
									</td>	
								</tr>
								
								<?php
									echo apply_filters ( 
														 'wpweb_fb_settings_submit_button', 
														 '<tr valign="top">
																<td colspan="2">
																	<input type="submit" value="' . __( 'ذخیره تغییرات', 'wpsapins' ) . '" id="wpw_auto_poster_set_submit" name="wpw_auto_poster_set_submit" class="button-primary">
																</td>
															</tr>'
														);
								?>
							</tbody>
						</table>
									
					</div><!-- .inside -->
							
			</div><!-- #autopost_instagram -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #ps-poster-autopost-instagram -->
<!-- end of the autopost to instagram meta box -->