<?php

// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

/**
 * Instagram Settings
 *
 * The html markup for the Instagram settings tab.
 *
 * @package Social Auto Poster
 * @since 2.6.9
 */

global $wpw_auto_poster_reposter_options, $wpw_auto_poster_model;

// model class
$model = $wpw_auto_poster_model;

$cat_posts_type = !empty( $wpw_auto_poster_reposter_options['ins_posting_cats'] ) ? $wpw_auto_poster_reposter_options['ins_posting_cats']: 'include';

$error_msgs = array();
$readonly = "";

// Check if gd library loaded or not.
if( !extension_loaded('gd') ) {
   $error_msgs[] = sprintf( __( 'Instagram requires %sGD%s PHP library enabled. Contact your host or server administrator to configure and install the missing library.', 'wpsapins' ), '<b>', '</b>' );
   $readonly = 'readonly';
}

// Check if Exif is enabled or not
if( !function_exists('exif_imagetype') ) {   
   $error_msgs[] = sprintf( __( 'Instagram requires %sExif%s PHP library enabled. Contact your host or server administrator to configure and install the missing library.', 'wpsapins' ), '<b>', '</b>' );
   $readonly = 'readonly';
}

$ins_exclude_cats = array();

// Get saved categories for ins to exclude from posting
if( !empty( $wpw_auto_poster_reposter_options['ins_post_type_cats'] ) ) {
	$ins_exclude_cats = $wpw_auto_poster_reposter_options['ins_post_type_cats'];
}

$ins_last_posted_page = ( !empty( $wpw_auto_poster_reposter_options['ins_last_posted_page'] ) ) ? $wpw_auto_poster_reposter_options['ins_last_posted_page'] : '1';

$exludes_post_ids = !empty( $wpw_auto_poster_reposter_options['ins_post_ids_exclude']) ? $wpw_auto_poster_reposter_options['ins_post_ids_exclude'] : '';

$repost_ins_global_message_template = isset( $wpw_auto_poster_reposter_options['repost_ins_global_message_template'] ) ? $wpw_auto_poster_reposter_options['repost_ins_global_message_template'] : '';

$repost_ins_custom_msg_options = isset( $wpw_auto_poster_reposter_options['repost_ins_custom_msg_options'] ) ? $wpw_auto_poster_reposter_options['repost_ins_custom_msg_options'] : 'global_msg';

if( $repost_ins_custom_msg_options == 'global_msg') {
	$post_msg_style = "display:none";
	$global_msg_style = "";
} else{
	$global_msg_style = "display:none";
	$post_msg_style = "";
}

?>

<!-- beginning of the instagram general settings meta box -->
<div id="wpw-auto-poster-instagram-general" class="post-box-container">
	<div class="metabox-holder">	
		<div class="meta-box-sortables ui-sortable">
			<div id="instagram_general" class="postbox">	
				<div class="handlediv" title="<?php _e( 'Click to toggle', 'wpsapins' ); ?>"><br /></div>
									
					<h3 class="hndle">
						<span style='vertical-align: top;'><?php _e( 'Instagram Settings', 'wpsapins' ); ?></span>
					</h3>
									
					<div class="inside">
						<?php if(!empty($error_msgs)) { ?>
							<div class="wpw-auto-poster-error">
                                <ul>
                                    <?php foreach ( $error_msgs as $error_msg ) { ?>
                                        <li><?php echo $error_msg;?></li>
                                    <?php } ?>
                                </ul>								
							</div>
						<?php } ?>				
						<table class="form-table">											
							<tbody>				
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[enable_instagram]"><?php _e( 'Repost to Instagram:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<input name="wpw_auto_poster_reposter_options[enable_instagram]" id="wpw_auto_poster_reposter_options[enable_instagram]" type="checkbox" value="1" <?php if( isset( $wpw_auto_poster_reposter_options['enable_instagram'] ) ) { checked( '1', $wpw_auto_poster_reposter_options['enable_instagram'] ); } ?> />
										<p><small><?php _e( 'Check this box, if you want to automatically post your new content to Instagram.', 'wpsapins' ); ?></small></p>
									</td>
								</tr>

								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[enable_instagram_for]"><?php _e( 'Repost for:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<ul>
										<?php 
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();
											
											if( !empty( $wpw_auto_poster_reposter_options['enable_instagram_for'] ) ) {
												$prevent_meta = $wpw_auto_poster_reposter_options['enable_instagram_for'];
											} else {
												$prevent_meta = array();
											}

											
											if( !empty( $wpw_auto_poster_options['ins_post_type_cats'] ) ) {
												$ins_post_type_cats = $wpw_auto_poster_reposter_options['ins_post_type_cats'];
											} else {
												$ins_post_type_cats = array();
											}

											 

											foreach( $all_types as $type ) {	
												
												if( !is_object( $type ) ) continue;															
													$label = @$type->labels->name ? $type->labels->name : $type->name;
													if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
													$selected = ( in_array( $type->name, $prevent_meta ) ) ? 'checked="checked"' : '';
													
										?>
															
											<li class="wpw-auto-poster-prevent-types">
												<input type="checkbox" id="wpw_auto_posting_instagram_prevent_<?php echo $type->name; ?>" name="wpw_auto_poster_reposter_options[enable_instagram_for][]" value="<?php echo $type->name; ?>" <?php echo $selected; ?>/>
																						
												<label for="wpw_auto_posting_instagram_prevent_<?php echo $type->name; ?>"><?php echo $label; ?></label>
											</li>
											
											<?php	} ?>
										</ul>
										<p><small><?php _e( 'Check each of the post types that you want to post automatically to Instagram.', 'wpsapins' ); ?></small></p>  
									</td>
								</tr>
									
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[ins_post_type_cats][]"><?php _e( 'Select Taxonomies:', 'wpsapins' ); ?></label> 
									</th>
									<td class="wpw-auto-poster-select">
										<div class="wpw-auto-poster-cats-option">
											<input name="wpw_auto_poster_reposter_options[ins_posting_cats]" id="ins_cats_include" type="radio" value="include" <?php checked( 'include', $cat_posts_type ); ?> />
											<label for="ins_cats_include"><?php _e( 'Include (Post only with)', 'wpsapins');?></label>
											<input name="wpw_auto_poster_reposter_options[ins_posting_cats]" id="ins_cats_exclude" type="radio" value="exclude" <?php checked( 'exclude', $cat_posts_type ); ?> />
											<label for="ins_cats_exclude"><?php _e( 'Exclude (Do not post)', 'wpsapins');?></label>
										</div>
										<select name="wpw_auto_poster_reposter_options[ins_post_type_cats][]" id="wpw_auto_poster_reposter_options[ins_post_type_cats]" class="ins_post_type_cats wpw-auto-poster-cats-tags-select" multiple="multiple">
											<?php

												$post_type_categories = wpw_auto_poster_get_all_categories_and_tags();

												if(!empty($post_type_categories)) {
													
													foreach($post_type_categories as $post_type => $post_data){

														echo '<optgroup label="'.$post_data['label'].'">';

														if(isset($post_data['categories']) && !empty($post_data['categories']) && is_array($post_data['categories'])){
															
															foreach($post_data['categories'] as $cat_slug => $cat_name){

																$selected ='';
																if( !empty( $ins_exclude_cats[$post_type] ) ) {
											                		$selected = ( in_array( $cat_slug, $ins_exclude_cats[$post_type] ) ) ? 'selected="selected"' : '';
											                	}
											                	
																echo '<option value="' . $post_type ."|".$cat_slug . '" '.$selected.'>'.$cat_name.'</option>';
															}

														}
														echo '</optgroup>';
													}
												}

											?>
										</select>
										<div class="wpw-ajax-loader"><img src="<?php echo WPW_AUTO_POSTER_IMG_URL."/icons/ajax-loader.gif";?>"/></div>
										<p><small><?php _e( 'Select the Taxonomies for each post type that you want to include or exclude for the repost.', 'wpsapins' ); ?></small></p>
									</td>
								</tr>
								<tr valign="top">
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[ins_post_ids_exclude]"><?php _e( 'Exclude Posts:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<textarea placeholder="1100,1200,1300" cols="35" id="wpw_auto_poster_reposter_options[ins_post_ids_exclude]" name="wpw_auto_poster_reposter_options[ins_post_ids_exclude]"><?php echo $exludes_post_ids; ?></textarea>
										<p><small>
											<?php _e( 'Enter the post ids seprated by comma(,) which you want to exclude for the posting.', 'wpsapins' ); ?>
										</small></p>
									</td>
								</tr>
								<tr valign="top" class="wpw-auto-poster-schedule-limit">
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[ins_posts_limit]"><?php _e( 'Maximum Posting per schedule:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<input id="wpw_auto_poster_reposter_options[ins_posts_limit]" name="wpw_auto_poster_reposter_options[ins_posts_limit]" type="text" value="<?php echo $wpw_auto_poster_reposter_options['ins_posts_limit']; ?>" />
										<p><small>
											<?php _e( 'Enter the maximum auto posting allowed on each schedule execution. Leave it empty for unlimited posting.', 'wpsapins' ); ?>
										</small></p>
									</td>
								</tr>

								<tr valign="top">
									<th scope="row">
										<label><?php _e( 'Custom Message Option:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<input id="ins_custom_global_msg" type="radio" name="wpw_auto_poster_reposter_options[repost_ins_custom_msg_options]" value="global_msg" <?php checked($repost_ins_custom_msg_options, 'global_msg', true);?>>
										<label for="ins_custom_global_msg" class="wpw-auto-poster-label"><?php _e( 'Global', 'wpsapins' ); ?></label>
	                                    
	                                    <input id="ins_custom_post_msg" type="radio" name="wpw_auto_poster_reposter_options[repost_ins_custom_msg_options]" value="post_msg" <?php checked($repost_ins_custom_msg_options, 'post_msg', true);?>>
	                                    <label for="ins_custom_post_msg" class="wpw-auto-poster-label"><?php _e( 'Individual Post Type Message', 'wpsapins' ); ?></label>
									</td>	
								</tr>
								<tr valign="top" style="<?php echo $global_msg_style; ?>" class="global_msg_tr">									
									<th scope="row">
										<label for="wpw_auto_poster_reposter_options[repost_ins_global_message_template]"><?php _e( 'پیام سفارشی:', 'wpsapins' ); ?></label>
									</th>
									<td>
										<textarea type="text" name="wpw_auto_poster_reposter_options[repost_ins_global_message_template]" id="wpw_auto_poster_reposter_options[repost_ins_global_message_template]" class="large-text"><?php echo $model->wpw_auto_poster_escape_attr( $repost_ins_global_message_template ); ?></textarea>
									</td>	
								</tr>

								<tr id="custom_post_type_templates_ins" style="<?php echo $post_msg_style; ?>" class="post_msg_tr">
									<th colspan="2">
									  	<ul>
									  		<?php
											$all_types = get_post_types( array( 'public' => true ), 'objects');
											$all_types = is_array( $all_types ) ? $all_types : array();

											foreach( $all_types as $type ) {	
											
												if( !is_object( $type ) ) continue;															
												$label = @$type->labels->name ? $type->labels->name : $type->name;

												if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
												
											?>
										    <li><a href="#tabs-<?php echo $type->name; ?>"><?php echo ucfirst($type->name); ?></a></li>
									  		<?php } ?>

									  	</ul>
									  	<?php 
									  	foreach( $all_types as $type ) {	
										
											if( !is_object( $type ) ) continue;															
											$label = @$type->labels->name ? $type->labels->name : $type->name;

											if( $label == 'Media' || $label == 'media' || $type->name == 'elementor_library' ) continue; // skip media
												
											$wpw_auto_poster_reposter_options['repost_ins_global_message_template_'.$type->name] = ( isset( $wpw_auto_poster_reposter_options['repost_ins_global_message_template_'.$type->name] ) ) ? $wpw_auto_poster_reposter_options['repost_ins_global_message_template_'.$type->name] : '';
									  	?>
									  		<table id="tabs-<?php echo $type->name; ?>">
												<tr valign="top">

													<th scope="row">
														<label for="wpw_auto_posting_ins_custom_msg_<?php echo $type->name; ?>"><?php echo __('پیام سفارشی', 'wpwautoposter'); ?>:</label>
													</th>

													<td>
														<textarea type="text" name="wpw_auto_poster_reposter_options[repost_ins_global_message_template_<?php echo $type->name; ?>]" id="wpw_auto_posting_ins_custom_msg_<?php echo $type->name; ?>" class="large-text"><?php echo $model->wpw_auto_poster_escape_attr( $wpw_auto_poster_reposter_options['repost_ins_global_message_template_'.$type->name] ); ?></textarea>
														<p><small><?php _e('Leave it empty for global custom message.','wpsapins');?></small></p>
													</td>	
												</tr>
											</table>
									<?php } ?>
									</th>
								</tr>	
								
								<tr valign="top">									
									<th scope="row"></th>
									<td>
										<p><small style="line-height: 20px;"><?php _e( 'Here you can enter default caption which will be used for the timeline. Leave it empty to use the post level caption. You can use following template tags within the caption template:', 'wpsapins' ); ?>
										<?php 
										$ins_template_str = '<br /><code>{first_name}</code> - ' . __('displays the first name,', 'wpsapins') .
							            '<br /><code>{last_name}</code> - ' . __('displays the last name,', 'wpsapins') .
							            '<br /><code>{display_name}</code> - ' . __('displays the display name,', 'wpsapins') .
							            '<br /><code>{title}</code> - ' . __('displays the default post title,', 'wpsapins') .
							            '<br /><code>{link}</code> - ' . __('displays the default post link,', 'wpsapins') .
							            '<br /><code>{full_author}</code> - ' . __('displays the full author name,', 'wpsapins') .
							            '<br /><code>{nickname_author}</code> - ' . __('displays the nickname of author,', 'wpsapins') .
							            '<br /><code>{post_type}</code> - ' . __(' displays the post type,', 'wpsapins') .
							            '<br /><code>{sitename}</code> - ' . __('displays the name of your site,', 'wpsapins') .
							            '<br /><code>{excerpt}</code> - ' . __('displays the post excerpt.', 'wpsapins').
							            '<br /><code>{hashtags}</code> - ' . __('displays the post tags as hashtags.', 'wpsapins').
							            '<br /><code>{hashcats}</code> - ' . __('displays the post categories as hashtags.', 'wpsapins').
							            '<br /><code>{content}</code> - ' . __('displays the post content.', 'wpsapins').
						           		'<br /><code>{content-digits}</code> - ' . __('displays the post content with define number of digits in template tag. <b>E.g. If you add template like {content-100} then it will display first 100 characters from post content.</b>', 'wpsapins').
						            	'<br /><code>{CF-CustomFieldName}</code> - ' . __('inserts the contents of the custom field with the specified name. <b>E.g. If your price is stored in the custom field "PRDPRICE" you will need to use {CF-PRDPRICE} tag.</b>', 'wpsapins');
							            print $ins_template_str;
							            ?>
										</small></p>
									</td>	
								</tr>
								<?php
									echo apply_filters ( 
														 'wpweb_reposter_ins_settings_submit_button', 
														 '<tr valign="top">
																<td colspan="2">
																	<input type="submit" value="' . __( 'Save Changes', 'wpsapins' ) . '" id="wpw_auto_poster_reposter_set_submit" name="wpw_auto_poster_reposter_set_submit" class="button-primary">
																</td>
															</tr>'
														);
								?>
							</tbody>
						</table>
						<input type="hidden" name="wpw_auto_poster_reposter_options[ins_last_posted_page]" value="<?php print $ins_last_posted_page;?>">		
					</div><!-- .inside -->
							
			</div><!-- #instagram_general -->
		</div><!-- .meta-box-sortables ui-sortable -->
	</div><!-- .metabox-holder -->
</div><!-- #wpw-auto-poster-instagram-general -->
<!-- end of the instagram general settings meta box -->
