<?php
// Exit if accessed directly
if (!defined('ABSPATH'))
    exit;

/**
 * Admin Class
 *
 * Handles generic Admin functionality and AJAX requests.
 *
 * @package Social Auto Poster - Instagram
 * @since 1.0.0
 */
class Wpw_Auto_Posting_Ins_AdminPages {
	

	/**
	 * Add instagram setting option to social auto poster settings
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_settings_panel_tab() {

	    add_action( 'wpw_auto_poster_settings_panel_tab', array( $this, 'wpw_auto_poster_instagram_setting_tab'), 55 );
	}




    /**
     * Display Instagram Setting Tab
     * 
     * Handle to display instagram setting tab
     *
     * @package Social Auto Poster - Instagram
     * @since 1.0.0
     */
    function wpw_auto_poster_instagram_setting_tab( $selected_tab ) {
        
        $selectedtab = !empty( $selected_tab ) && $selected_tab == 'instagram' ? ' nav-tab-active' : '';
        ?>
            <a class="nav-tab <?php echo $selectedtab; ?>" href="#wpw-auto-poster-tab-instagram" attr-tab="instagram">
                <img src="<?php echo WPW_AUTO_POSTER_INS_IMG_URL; ?>/instagram_set.png" width="24" height="24" alt="ins" title="<?php _e( 'Instagram', 'wpsapins' ); ?>" />
            </a>
        <?php
    }


	/**
	 * Add hook instagram setting option to social auto poster settings
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_settings_panel_tab_content() {

	    add_action( 'wpw_auto_poster_settings_panel_tab_content', array( $this, 'wpw_auto_poster_instagram_setting_tab_content'), 55 );
	}

	/**
     * Display Instagram Setting Tab Content
     * 
     * Handle to display instagram setting tab content
     *
     * @package Social Auto Poster - Instagram
     * @since 1.0.0
     */
    function wpw_auto_poster_instagram_setting_tab_content( $selected_tab ) {
    
        $selectedtabcontent = !empty( $selected_tab ) && $selected_tab == 'instagram' ? ' wpw-auto-poster-selected-tab' : '';
        ?>
            <div class="wpw-auto-poster-tab-content <?php echo $selectedtabcontent; ?>" id="wpw-auto-poster-tab-instagram"> 
                    
                <?php
            
                // Instagram Settings
                include( WPW_AUTO_POSTER_INS_ADMIN . '/forms/wpw-auto-poster-instagram.php' );
            
                ?>
            
            </div><!--#wpw-auto-poster-tab-instagram-->
        <?php
    }

	/**
	 * Action Hook callback function
	 *
	 * Add instagram tab to reposter settings
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_reposter_ins_settings_panel_tab() {

	    add_action( 'wpw_auto_poster_reposter_settings_panel_tab', array( $this, 'wpw_auto_poster_reposter_instagram_setting_tab'), 55 );
	}

	/**
     * Display Instagram Setting Tab
     * 
     * Handle to display instagram setting tab
     *
     * @package Social Auto Poster - Instagram
     * @since 1.0.0
     */
    function wpw_auto_poster_reposter_instagram_setting_tab( $selected_tab ) {
        
        $selectedtab = !empty( $selected_tab ) && $selected_tab == 'instagram' ? ' nav-tab-active' : '';
        ?>
            <a class="nav-tab <?php echo $selectedtab; ?>" href="#wpw-auto-poster-tab-instagram" attr-tab="instagram">
                <img src="<?php echo WPW_AUTO_POSTER_INS_IMG_URL; ?>/instagram_set.png" width="24" height="24" alt="ins" title="<?php _e( 'Instagram', 'wpsapins' ); ?>" />
            </a>
        <?php
    }


	/**
	 * Action Hook callback function
	 *
	 * Add Instagram Setting tab content
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_reposter_ins_settings_panel_tab_content() {

	    add_action( 'wpw_auto_poster_reposter_settings_panel_tab_content', array( $this, 'wpw_auto_poster_reposter_instagram_setting_tab_content'), 55 );
	}

	/**
     * Display Instagram Setting Tab Content
     * 
     * Handle to display instagram setting tab content
     *
     * @package Social Auto Poster - Instagram
     * @since 1.0.0
     */
    function wpw_auto_poster_reposter_instagram_setting_tab_content( $selected_tab ) {
    
        $selectedtabcontent = !empty( $selected_tab ) && $selected_tab == 'instagram' ? ' wpw-auto-poster-selected-tab' : '';
        ?>
            <div class="wpw-auto-poster-tab-content <?php echo $selectedtabcontent; ?>" id="wpw-auto-poster-tab-instagram"> 
                    
                <?php
            
                // Instagram Settings
                include( WPW_AUTO_POSTER_INS_ADMIN . '/forms/reposter/wpw-auto-poster-reposter-instagram.php' );
            
                ?>
            
            </div><!--#wpw-auto-poster-reposter-tab-instagram-->
        <?php
    }

	/**
	 * Action Hook callback function
	 *
	 * Manage schedule instagram list
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_manage_schedules_list( $selected_tab, $admin_url ) {
	    ?>
	    <a class="nav-tab <?php echo $selected_tab == 'instagram' ? 'nav-tab-active' : ''; ?>" href="<?php echo add_query_arg( array( 'page' =>  $_GET['page'], 'tab' =>  'instagram' ), $admin_url );?>">
	        <img src="<?php echo WPW_AUTO_POSTER_INS_IMG_URL; ?>/instagram_set.png" width="24" height="24" alt="ins" title="<?php _e( 'Instagram', 'wpsapins' ); ?>" />
	    </a>
	    <?php
	}

	/**
	 * Action Hook callback function
	 *
	 * Handle to show instagram tab to social auto poster meta tab
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_tab_add_meta_boxes( $poster_meta ) {

		global $wpw_auto_poster_options;


	    $prefix = WPW_AUTO_POSTER_META_PREFIX;
	    
	    $defaulttabon = false;

	    //Check Post status
	    $post_id = !empty($_GET['post']) ? $_GET['post'] :'';

	    if (!isset($wpw_auto_poster_options['prevent_post_ins_metabox']) || empty($wpw_auto_poster_options['prevent_post_ins_metabox'])) { //check if not allowed for individual post in settings page
	        $insmetatab = array(
	            'class' => 'wpw_instagram', //unique class name of each tabs
	            'title' => __('Instagram', 'wpsapins'), //  title of tab
	            'active' => $defaulttabon //it will by default make tab active on page load
	        );

	        $defaulttabon = false; //when instagram is on then inactive other tab by default
	        //initiate tabs in metabox
	        $poster_meta->addTabs($insmetatab);

	        //Get instagram account details
	        $ins_account_details = get_option('wpw_auto_poster_ins_account_details', array());
	        $ins_users = array();

	        if(!empty($ins_account_details)){
	            foreach ($ins_account_details as $key => $ins_account) {
	                $ins_user_data = explode("|",$ins_account);
	                $ins_users[$ins_account] = trim($ins_user_data[0]); 
	            }
	        }

	        if (empty($ins_users) || count($ins_users) < 1) {

	            $poster_meta->addGrantPermission($prefix . 'ins_warning', array('desc' => __('نام کاربری / رمزعبور اینستاگرام خود را در صفحه تنظیمات وارد کنید ، در غیر اینصورت ارسال به اینستاگرام کار نخواهد کرد.', 'wpsapins'), 'url' => add_query_arg(array('page' => 'wpw-auto-poster-settings'), admin_url('admin.php')), 'urltext' => __('به صفحه تنظیمات بروید', 'wpsapins'), 'tab' => 'wpw_instagram'));
	        } else if( !extension_loaded('gd') ) {
	            $poster_meta->addGrantPermission($prefix . 'ins_warning', array('desc' => sprintf( __( 'اینستاگرام به %sکتابخانه %s PHP فعال شده است. برای پیکربندی و نصب کتابخانه با مدیر میزبان یا سرور خود تماس بگیرید.', 'wpsapins' ), '<b>', '</b>' ), 'url' => '', 'urltext' =>'', 'tab' => 'wpw_instagram'));
	        } else if( !function_exists('exif_imagetype') ) {
	            $poster_meta->addGrantPermission($prefix . 'ins_warning', array('desc' => sprintf( __( 'اینستاگرام به   %sExif%sکتابخانه PHP فعال شده است. برای پیکربندی و نصب کتابخانه با مدیر میزبان یا سرور خود تماس بگیرید.', 'wpsapins' ), '<b>', '</b>' ), 'url' => '', 'urltext' =>'', 'tab' => 'wpw_instagram'));
	        }

	        $poster_meta->addTweetStatus($prefix . 'ins_published_on_ins', array('name' => __('وضعیت:', 'wpsapins'), 'desc' => __('وضعیت جدول زمانی اینستاگرام همانطور که منتشر شد/unpublished/scheduled.', 'wpsapins'), 'tab' => 'wpw_instagram'));

	        $post_status = get_post_meta($post_id, $prefix.'ins_published_on_ins', true );
	        $post_label  = __('انتشار پست در اینستاگرام:', 'wpsapins');
	        $post_desc   = __('این پست را در جدول زمانی اینستاگرام منتشر کنید.', 'wpsapins');

	        if( $post_status == 1 && empty($schedule_option)) {
	            $post_label = __('Re-publish Post On Instagram:', 'wpsapins');
	            $post_desc  = __('Re-publish this Post to Instagram timeline.', 'wpsapins');
	        } elseif ( ( $post_status == 2 ) || ( $post_status == 1 && !empty($schedule_option) ) ) {
	            $post_label = __('Re-schedule Post On Instagram:', 'wpsapins');
	            $post_desc  = __('Re-schedule this Post to Instagram timeline.', 'wpsapins');
	        } elseif ( empty($post_status) && !empty($schedule_option) ) {
	            $post_label  = __('Schedule Post On Instagram:', 'wpsapins');
	            $post_desc   = __('Schedule this Post to Instagram timeline.', 'wpsapins');
	        }

	        $post_desc .= '<br>'.sprintf( __( 'اگر %sEable فعال خودکار ارسال در اینستاگرام%s را در تنظیمات جهانی فعال کرده اید ، دیگر نیازی به چک کردن این کادر برای انتشار / برنامه ریزی پست ندارید. این تنظیم فقط برای ارسال مجدد یا ارسال مجدد پست در اینستاگرام است.', 'wpsapins'), '<strong>', '</strong>');
	        $post_desc .= '<br><p style="color:#c83737;" classs="wpw-auto-poster-meta"><strong>'.__('Note:', 'wpsapins').'</strong> '. sprintf( __( 'این تنظیم فقط یک رویداد برای انتشار مجدد / تنظیم مجدد محتوا است ، هیچ ارزشی را در%s.دیتابیس %s.ذخیره نمی کند.', 'wpsapins'), '<strong>','</strong>').'</p>';

	        //post to instagram
	        $poster_meta->addPublishBox($prefix . 'post_to_instagram', array('name' => $post_label, 'desc' => $post_desc, 'tab' => 'wpw_instagram'));

	        //Immediate post to instagram
	        if( !empty($schedule_option)) {
	            $poster_meta->addPublishBox($prefix . 'immediate_post_to_instagram', array('name' => __('Immediate Posting On Instagram:', 'wpsapins'), 'desc' => 'Immediately publish this post to Instagram.', 'tab' => 'wpw_instagram'));
	        }


	        //post to this account
	        $poster_meta->addSelect($prefix . 'ins_user_id', $ins_users, array('name' => __('ارسال به این حساب کاربری اینستاگرام', 'wpsapins') . '(' . __('s', 'wpsapins') . '):', 'std' => array(''), 'desc' => __('حسابی را که می خواهید ارسال کنید انتخاب کنید. این تنظیمات بر تنظیمات جهانی غلبه دارد. برای استفاده از Defa جهانی ، آن را خالی بگذاریدults.', 'wpsapins'), 'multiple' => true, 'placeholder' => __('Default', 'wpsapins'), 'tab' => 'wpw_instagram'));

	        //post image 
	        $poster_meta->addImage($prefix . 'ins_post_image', array('name' => __('تصویر پست:', 'wpsapins'), 'desc' => __('در اینجا می توانید یک تصویر پیش فرض را که برای پست تایم اینستاگرام استفاده خواهد شد بارگذاری کنید. برای استفاده از تصویر برجسته آن را خالی بگذارید. اگر تصویر برجسته نیز خالی باشد ، از صفحه تنظیمات تصویر پیش فرض را می گیرد.', 'wpsapins').'<br><br><strong>'.__('Note:', 'wpsapins').' </strong>'.__('Instagram require atleast one image for posting.','wpsapins').'<b>'. __(' Recommended image width between 320 to 1080 pixels.', 'wpsapins').'</b><br><br>'.__('اگر عرض تصویر کمتر از 320 پیکسل باشد ، به طور خودکار به 320 پیکسل افزایش می یابد. اگر عرض تصویر از 1080 پیکسل بیشتر باشد ، به طور خودکار به 1080 پیکسل تغییر می کند.', 'wpsapins'), 'tab' => 'wpw_instagram', 'show_path' => true));

	        //post message
	        $poster_meta->addTextarea($prefix . 'ins_custom_status_msg', array('default' => '', 'validate_func' => 'escape_html', 'name' => __('پبام سفارشی:', 'wpsapins'), 'desc' => __('در اینجا می توانید یک متن شرح زیر را وارد کنید. برای استفاده از پیش فرض از صفحه تنظیمات ، آن را خالی بگذارید. می توانید از برچسب های الگوی زیر در متن شرح زیر استفاده کنیدt:', 'wpsapins') .
	            '<br /><code>{first_name}</code> - ' . __('displays the first name,', 'wpsapins') .
	            '<br /><code>{last_name}</code> - ' . __('displays the last name,', 'wpsapins') .
	            '<br /><code>{display_name}</code> - ' . __('displays the display name,', 'wpsapins') .
	            '<br /><code>{title}</code> - ' . __('displays the post title,', 'wpsapins') .
	            '<br /><code>{excerpt}</code> - ' . __('displays the short post description,', 'wpsapins') .
	            '<br /><code>{link}</code> - ' . __('displays the post link,', 'wpsapins') .
	            '<br /><code>{full_author}</code> - ' . __('displays the full author name,', 'wpsapins') .
	            '<br /><code>{nickname_author}</code> - ' . __('displays the nickname of author,', 'wpsapins') .
	            '<br /><code>{post_type}</code> - ' . __('displays the post type,', 'wpsapins') .
	            '<br /><code>{sitename}</code> - ' . __('displays the name of your site.', 'wpsapins').
	            '<br /><code>{hashtags}</code> - ' . __('displays the post tags as hashtags.', 'wpsapins').
	            '<br /><code>{hashcats}</code> - ' . __('displays the post categories as hashtags.', 'wpsapins').
	            '<br /><code>{content}</code> - ' . __('displays the post content.', 'wpsapins').
	            '<br /><code>{content-digits}</code> - ' . __('محتوای ارسال را با تعداد مشخصی از رقم در برچسب قالب نمایش می دهد.<b> به عنوان مثال، اگر الگویی مانند {content-100 add اضافه کنید ، سپس 100 حرف اول را از محتوای ارسال نمایش می دهد.</b>', 'wpsapins').
	            '<br /><code>{CF-CustomFieldName}</code> - ' . __('محتویات زمینه دلخواه را با نام مشخص شده وارد می کند. <b> به عنوان مثال، اگر قیمت شما در قسمت "PRDPRICE" سفارشی ذخیره می شود ، باید از برچسب {CF-PRDPRICE use استفاده کنید.</b>', 'wpsapins')
	            , 'tab' => 'wpw_instagram'));
	    }
	}

	/**
	 * Add instagram option to all social types
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_handle_social_type( $social_types ) {

	    $social_types['ins'] = __( 'Instagram', 'wpsapins' );

	    return $social_types;
	}

	/**
	 * Add instagram option to all social types
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_handle_social_type_data( $social_types ) {

	    $social_types['ins'] = 'instagram';

	    return $social_types;
	}


	/**
	 * Filter Hook callback function
	 *
	 * Manage posting reports for instagram
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_handle_posting_reports( $social_array ) {

		array_push($social_array[0], __('Instagram', 'wpsapins'));
	    return $social_array;
	}


	/**
	 * Filter Hook callback function
	 *
	 * Handle to show instagram posting logs
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_hide_posting_logs( $post_args, $insta_posts ) {

		unset($post_args['post__not_in']);
		return $post_args;
	}

	/**
	 * Set Instagram key for posting report option.
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_social_key( $social_keys){
	    $social_keys[] = 'ins';
	    return $social_keys;
	}


	/**
	 * Add Instagram for posting report option
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_ins_social_values( $social_values){
	    $social_values[] = __('Instagram', 'wpsapins');
	    return $social_values;
	}


	/**
	 * Hook callback function
	 *
	 * Form for category account selection for instagram
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_category_ins_form_fields() {
	    print '<table class="form-table">';
	    include_once( WPW_AUTO_POSTER_INS_ADMIN . '/forms/wpw-auto-poster-category-social-ins-fields.php' );
	    print '<input type="hidden" name="wpw_auto_category_posting" value="1">';
	    print '</table>';
	}


	/**
	 * Filter Hook callback function
	 *
	 * Handle to set instagram values for posting chart report
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_social_reports_instagran_values( $final_array, $values ){
	    $instagram  = !empty( $value['ins'] )? $value['ins'] : 0;
	    $final_array[] = $instagram;
	    return $final_array;
	}

	/**
	 * Filter Hook callback function
	 *
	 * Handle to set instagram default values for posting chart report
	 *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
	 */
	function wpw_auto_poster_report_ins_default_ins_option_values( $default_arr ) {
	    $default_arr[] = 0;
	    return $default_arr;
	}


	/**
     * Adding Hooks
     *
	 * @package Social Auto Poster - Instagram
	 * @since 1.0.0
    */
    public function add_hooks() {

    	// social auto poster instagram settings
        add_action('wpw_auto_poster_settings_panel_tab_after_ba', array( $this , 'wpw_auto_poster_ins_settings_panel_tab') );

        add_action('wpw_auto_poster_settings_panel_tab_content_after_ba', array( $this ,'wpw_auto_poster_ins_settings_panel_tab_content') );

        // social auto poster reposter instagram settings
        add_action('wpw_auto_poster_reposter_settings_panel_tab_after_ba', array( $this ,'wpw_auto_poster_reposter_ins_settings_panel_tab') );

        add_action('wpw_auto_poster_reposter_settings_panel_tab_content_after_ba', array( $this ,'wpw_auto_poster_reposter_ins_settings_panel_tab_content') );

        // manage schedule instagram list
        add_action('wpw_auto_poster_manage_schedules_list_after_ba', array( $this ,'wpw_auto_poster_ins_manage_schedules_list') , 10, 2);

        add_action('wpw_auto_poster_tab_add_meta_boxes_after_ba', array( $this ,'wpw_auto_poster_ins_tab_add_meta_boxes') );

        // Add instagram option to all social types
        add_filter('wpw_auto_poster_handle_social_type', array( $this ,'wpw_auto_poster_ins_handle_social_type') );

        add_filter('wpw_auto_poster_handle_social_type_data', array( $this ,'wpw_auto_poster_ins_handle_social_type_data') );

        add_filter('wpw_auto_poster_handle_posting_reports', array( $this ,'wpw_auto_poster_ins_handle_posting_reports') );

        /* Hide instagram posting logs */
        add_filter('wpw_auto_poster_get_posting_logs_args', array( $this ,'wpw_auto_poster_ins_hide_posting_logs') , 10, 2 );

        add_filter( 'wpw_auto_poster_admin_notices_social_keys', array( $this, 'wpw_auto_poster_ins_social_key') );

        add_filter( 'wpw_auto_poster_admin_notices_social_values', array( $this, 'wpw_auto_poster_ins_social_values') );

        add_action('wpw_auto_poster_category_ins_form', array( $this,'wpw_auto_poster_category_ins_form_fields') );

        add_filter('wpw_auto_poster_social_reports_values', array( $this, 'wpw_auto_poster_social_reports_instagran_values') , 10,2);

        add_filter('wpw_auto_poster_report_default_option_values', array( $this, 'wpw_auto_poster_report_ins_default_ins_option_values') );

    }

}