<?php

if (!defined('ABSPATH')) exit;

?>
<div class="daftplugAdminPage_subpage -compatibility -flex12" data-subpage="compatibility">
	<div class="daftplugAdminPage_content -flex8">
        <div class="daftplugAdminSettings -flexAuto">
            <form name="daftplugAdminSettings_form" class="daftplugAdminSettings_form" data-nonce="<?php echo wp_create_nonce("{$this->optionName}_settings_nonce"); ?>" spellcheck="false" autocomplete="off">
                <fieldset class="daftplugAdminFieldset" data-feature-type="new">
                    <h4 class="daftplugAdminFieldset_title"><?php esc_html_e('Plugin Suppression', $this->textDomain); ?></h4>
                    <p class="daftplugAdminFieldset_description"><?php esc_html_e('هنگامی که یک افزونه علامت گذاری را اضافه می کند که در AMP مجاز نیست ، شما می توانید Instantify را برای حذف آن اضافه کنید ، یا می توانید افزونه را در صفحات AMP سرکوب کنید.', $this->textDomain); ?></p>
                    <div class="daftplugAdminField">
                        <p class="daftplugAdminField_description"><?php esc_html_e('سرکوب پلاگین را در صفحات AMP فعال یا غیرفعال کنید. اگر روشن باشد ، گزینه زیر را برای انتخاب پلاگین های فعال برای سرکوب در صفحات AMP مشاهده خواهید کرد.', $this->textDomain); ?></p>
                        <label for="ampPluginSuppression" class="daftplugAdminField_label -flex4"><?php esc_html_e('Plugin Suppression', $this->textDomain); ?></label>
                        <label class="daftplugAdminInputCheckbox -flexAuto">
                            <input type="checkbox" name="ampPluginSuppression" id="ampPluginSuppression" class="daftplugAdminInputCheckbox_field" <?php checked(daftplugInstantify::getSetting('ampPluginSuppression'), 'on'); ?>>
                        </label>
                    </div>
                    <div class="daftplugAdminField -ampPluginSuppressionDependentHideD">
                        <p class="daftplugAdminField_description"><?php esc_html_e('افزونه ها را برای سرکوب انتخاب کنید. ما توصیه می کنیم افزونه های موجود در صفحات AMP را که معروف به ایجاد مشکل هستند و یا برای عملکرد صحیح آنها نیاز به جاوا اسکریپت دارد سرکوب کنید زیرا جاوا اسکریپت در صفحات AMP مجاز نیست.', $this->textDomain); ?></p>
                        <label for="ampPluginSuppression" class="daftplugAdminField_label -flex4"><?php esc_html_e('Suppressible Plugins', $this->textDomain); ?></label>
                        <div class="daftplugAdminInputSelect -flexAuto">
                            <select multiple name="ampPluginSuppressionList" id="ampPluginSuppressionList" class="daftplugAdminInputSelect_field" data-placeholder="<?php esc_html_e('Suppressible Plugins', $this->textDomain); ?>" autocomplete="off" required>
                            <?php foreach (daftplugInstantifyAmpAdminCompatibility::getSuppressiblePlugins() as $pluginFile => $pluginData) { ?>
                                    <option value="<?php echo $pluginFile; ?>" <?php selected(true, in_array($pluginFile, (array)daftplugInstantify::getSetting('ampPluginSuppressionList'))); ?>><?php echo $pluginData['Name']; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                </fieldset>
                <fieldset class="daftplugAdminFieldset" data-feature-type="new">
                    <h4 class="daftplugAdminFieldset_title"><?php esc_html_e('منوی نوار کناری AMP', $this->textDomain); ?></h4>
                    <p class="daftplugAdminFieldset_description"><?php esc_html_e('اگر وب سایت شما از JavaScript برای تغییر منوی همبرگر در دستگاه های تلفن همراه استفاده می کند ، به این معنی است که دیگر در صفحات AMP کار نخواهد کرد زیرا AMP با جاوا اسکریپت از این صفحه جلوگیری می کند. در این صورت ، می توانیم یک منوی موبایل چسبنده با پشتیبانی AMP سفارشی برای شما ایجاد کنیم. شما فقط باید منوی مورد نظر خود را برای منوی نوار کناری AMP انتخاب کنید.', $this->textDomain); ?></p>
                    <div class="daftplugAdminField">
                        <p class="daftplugAdminField_description"><?php esc_html_e('منوی نوار کناری AMP را فعال یا غیرفعال کنید.', $this->textDomain); ?></p>
                        <label for="ampSidebarMenu" class="daftplugAdminField_label -flex4"><?php esc_html_e('AMP Sidebar Menu', $this->textDomain); ?></label>
                        <label class="daftplugAdminInputCheckbox -flexAuto">
                            <input type="checkbox" name="ampSidebarMenu" id="ampSidebarMenu" class="daftplugAdminInputCheckbox_field" <?php checked(daftplugInstantify::getSetting('ampSidebarMenu'), 'on'); ?>>
                        </label>
                    </div>
                    <div class="daftplugAdminField -ampSidebarMenuDependentDisableD">
                        <p class="daftplugAdminField_description"><?php esc_html_e('منویی را که می خواهید در منوی نوار کناری AMP استفاده شود انتخاب کنید. باید منوی اصلی شما باشد.', $this->textDomain); ?></p>
                        <label for="ampSidebarMenuId" class="daftplugAdminField_label -flex4"><?php esc_html_e('AMP Menu', $this->textDomain); ?></label>
                        <div class="daftplugAdminInputSelect -flexAuto">
                            <select name="ampSidebarMenuId" id="ampSidebarMenuId" class="daftplugAdminInputSelect_field" data-placeholder="<?php esc_html_e('AMP Menu', $this->textDomain); ?>" autocomplete="off" required>
                                <?php foreach (get_terms('nav_menu') as $menu) { ?>
                                    <option value="<?php echo $menu->term_id; ?>" <?php selected(daftplugInstantify::getSetting('ampSidebarMenuId'), $menu->term_id) ?>><?php echo $menu->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="daftplugAdminField -ampSidebarMenuDependentDisableD">
                        <p class="daftplugAdminField_description"><?php esc_html_e('رنگ پس زمینه منوی نوار کناری AMP خود را انتخاب کنید.', $this->textDomain); ?></p>
                        <label for="ampSidebarMenuBgColor" class="daftplugAdminField_label -flex4"><?php esc_html_e('رنگ پس زمینه منو', $this->textDomain); ?></label>
                        <div class="daftplugAdminInputColor -flexAuto">
                            <input type="text" name="ampSidebarMenuBgColor" id="ampSidebarMenuBgColor" class="daftplugAdminInputColor_field" value="<?php echo daftplugInstantify::getSetting('ampSidebarMenuBgColor'); ?>" data-placeholder="<?php esc_html_e('رنگ پس زمینه منو', $this->textDomain); ?>" required>
                        </div>
                    </div>
                    <div class="daftplugAdminField -ampSidebarMenuDependentDisableD">
                        <p class="daftplugAdminField_description"><?php esc_html_e('موقعیت دکمه منوی نوار کناری AMP خود را در وب سایت خود انتخاب کنید.', $this->textDomain); ?></p>
                        <label for="ampSidebarMenuPosition" class="daftplugAdminField_label -flex4"><?php esc_html_e('موقعیت دکمه منو', $this->textDomain); ?></label>
                        <div class="daftplugAdminInputSelect -flexAuto">
                            <select name="ampSidebarMenuPosition" id="ampSidebarMenuPosition" class="daftplugAdminInputSelect_field" data-placeholder="<?php esc_html_e('Menu Button Position', $this->textDomain); ?>" autocomplete="off" required>
                                <option value="left" <?php selected(daftplugInstantify::getSetting('ampSidebarMenuPosition'), 'left') ?>><?php esc_html_e('Left', $this->textDomain); ?></option>
                                <option value="right" <?php selected(daftplugInstantify::getSetting('ampSidebarMenuPosition'), 'right') ?>><?php esc_html_e('Right', $this->textDomain); ?></option>
                            </select>
                        </div>
                    </div>
                </fieldset>
                <fieldset class="daftplugAdminFieldset" data-feature-type="new">
                    <h4 class="daftplugAdminFieldset_title"><?php esc_html_e('AMP Custom CSS', $this->textDomain); ?></h4>
                    <p class="daftplugAdminFieldset_description"><?php esc_html_e('Instantify از صفحه های قالب و قالب های تم وردپرس فعال شما برای صفحات AMP استفاده می کند ، بنابراین هرگونه تغییر CSS در قالب شما از طریق فایل style.css ، تنظیم کننده وردپرس یا هر روش دیگر در URL های AMP شما اعمال می شود. با این حال ، اگر می خواهید قوانین CSS را فقط در URL های AMP خود اعمال کنید ، می توانید قوانین خود را در اینجا اضافه کنید.', $this->textDomain); ?></p>
                    <div class="daftplugAdminField">
                        <p class="daftplugAdminField_description"><?php esc_html_e('CSS سفارشی خود را وارد کنید. لطفا توجه داشته باشید که این قوانین فقط در صفحات AMP اعمال خواهد شد.', $this->textDomain); ?></p>
                        <label for="ampCustomCss" class="daftplugAdminField_label -flex3"><?php esc_html_e('Custom CSS', $this->textDomain); ?></label>
                        <div class="daftplugAdminInputTextarea -flexAuto">
                            <textarea name="ampCustomCss" id="ampCustomCss" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" rows="4"><?php echo htmlspecialchars(wp_unslash(daftplugInstantify::getSetting('ampCustomCss'))); ?></textarea>
                        </div>
                    </div>
                </fieldset>
                <div class="daftplugAdminSettings_submit">
                    <button type="submit" class="daftplugAdminButton -submit" data-submit="<?php esc_html_e('Save Settings', $this->textDomain); ?>" data-waiting="<?php esc_html_e('Waiting', $this->textDomain); ?>" data-submitted="<?php esc_html_e('Settings Saved', $this->textDomain); ?>" data-failed="<?php esc_html_e('Saving Failed', $this->textDomain); ?>"></button>
                </div>
            </form>
        </div>
    </div>
</div>