<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\IpMessaging;

use Twilio\Domain;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceContext;
use Twilio\ListResource;
use Twilio\Rest\IpMessaging\V1\CredentialContext;
use Twilio\Rest\IpMessaging\V1\CredentialList;
use Twilio\Rest\IpMessaging\V1\ServiceContext;
use Twilio\Rest\IpMessaging\V1\ServiceList;
use Twilio\Version;

/**
 * @property CredentialList credentials
 * @property ServiceList services
 * @method CredentialContext credentials(string $sid)
 * @method ServiceContext services(string $sid)
 */
class V1 extends Version {
    protected $_credentials = null;
    protected $_services = null;

    /**
     * Construct the V1 version of IpMessaging
     * 
     * @param Domain $domain Domain that contains the version
     * @return V1 V1 version of IpMessaging
     */
    public function __construct(Domain $domain) {
        parent::__construct($domain);
        $this->version = 'v1';
    }

    /**
     * Magic getter to lazy load root resources
     *
     * @param string $name Resource to return
     *
     * @return ListResource The requested resource
     * @throws TwilioException For unknown resource
     */
    public function __get($name) {
        $method = 'get' . ucfirst($name);
        if (method_exists($this, $method)) {
            return $this->$method();
        }

        throw new TwilioException('Unknown resource ' . $name);
    }

    /**
     * Magic caller to get resource contexts
     *
     * @param string $name Resource to return
     * @param array $arguments Context parameters
     *
     * @return InstanceContext The requested resource context
     * @throws TwilioException For unknown resource
     */
    public function __call($name, $arguments) {
        $property = $this->$name;
        if (method_exists($property, 'getContext')) {
            return call_user_func_array(array($property, 'getContext'), $arguments);
        }

        throw new TwilioException('Resource does not have a context');
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        return '[Twilio.IpMessaging.V1]';
    }

    /**
     * @return CredentialList
     */
    protected function getCredentials() {
        if (!$this->_credentials) {
            $this->_credentials = new CredentialList($this);
        }
        return $this->_credentials;
    }

    /**
     * @return ServiceList
     */
    protected function getServices() {
        if (!$this->_services) {
            $this->_services = new ServiceList($this);
        }
        return $this->_services;
    }
}